/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.bindings.VariableBinding;
import kenya.eclipse.multieditor.kenya.util.SourceCodeLocationComparator;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Node;
import minijava.node.Switch;
import minijava.node.TIdentifier;

class LocalVariableHelper
extends DepthFirstAdapter {
    private TIdentifier name;
    private IFunction func;
    private IBinding dec;

    LocalVariableHelper(TIdentifier n, IFunction f) {
        this.func = f;
        this.name = n;
    }

    public IBinding getSignature() {
        this.func.getDeclarationNode().apply((Switch)this);
        return this.dec;
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        if (!this.occursBefore((Node)node.getIdentifier(), (Node)this.name)) {
            return;
        }
        if (node.getIdentifier().toString().equals(this.name.toString())) {
            String d = NodeToString.toString((Node)node);
            if (node.getArrayInitialiser() != null) {
                String init = NodeToString.toString((Node)node.getArrayInitialiser());
                d = d.substring(0, d.indexOf(init) - 1);
            }
            this.dec = new VariableBinding((Node)this.name, (Node)node, node.getType(), d);
        }
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        if (!this.occursBefore((Node)node.getIdentifier(), (Node)this.name)) {
            return;
        }
        if (node.getIdentifier().toString().equals(this.name.toString())) {
            String d = NodeToString.toString((Node)node);
            if (node.getInitialiser() != null) {
                String init = NodeToString.toString((Node)node.getInitialiser());
                d = d.substring(0, d.indexOf(init) - 1);
            }
            this.dec = new VariableBinding((Node)this.name, (Node)node, node.getType(), d);
        }
    }

    private boolean occursBefore(Node n1, Node n2) {
        ISourceCodeLocation l1 = NodeTools.getLocation(n1);
        ISourceCodeLocation l2 = NodeTools.getLocation(n2);
        return SourceCodeLocationComparator.getInstance().compare(l1, l2) <= 0;
    }
}

