/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.multieditor.kenya.util.SourceCodeLocationComparator;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAccess;
import minijava.node.AArrayAllocate;
import minijava.node.AArrayCommaInitList;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayFieldAccess;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AArrayIntExpression;
import minijava.node.AAssertStatement;
import minijava.node.AAssignment;
import minijava.node.AAssignmentForLeftStat;
import minijava.node.AAssignmentForRightStat;
import minijava.node.AAssignmentStatement;
import minijava.node.ABasicTypeType;
import minijava.node.ABlock;
import minijava.node.ABlockElseFollow;
import minijava.node.ABlockStatement;
import minijava.node.ABooleanBasicType;
import minijava.node.ABoolexpExpression;
import minijava.node.ABoolliteralFactor;
import minijava.node.ABreakStatement;
import minijava.node.ACasePossibleCase;
import minijava.node.ACharBasicType;
import minijava.node.ACharliteralFactor;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassInnerDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AColonString;
import minijava.node.ACommaArrayInit;
import minijava.node.ACommaEnumList;
import minijava.node.ACommaExp;
import minijava.node.ACommaType;
import minijava.node.ACommaTypeName;
import minijava.node.AConstDecDeclaration;
import minijava.node.ADNumber;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ADivTerm;
import minijava.node.ADoubleBasicType;
import minijava.node.ADynamicArrayInitialiser;
import minijava.node.AElsePart;
import minijava.node.AEmptyDeclarations;
import minijava.node.AEmptyStatements;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AEqEquality;
import minijava.node.AEqualityBoolTerm;
import minijava.node.AExpActualParamList;
import minijava.node.AExpressionFactor;
import minijava.node.AFactorPostfixExp;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AFieldaccessFactor;
import minijava.node.AForStatement;
import minijava.node.AForUnaryStatement;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AFunctionFactor;
import minijava.node.AFunctioncallForRightStat;
import minijava.node.AFunctioncallStatement;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.AINumber;
import minijava.node.AIfElseFollow;
import minijava.node.AIfStat;
import minijava.node.AIfStatement;
import minijava.node.AInitialiser;
import minijava.node.AInnerDecForLeftStat;
import minijava.node.AInnerDecStatement;
import minijava.node.AIntBasicType;
import minijava.node.AJavaForControl;
import minijava.node.AListActualParamList;
import minijava.node.AListDeclarations;
import minijava.node.AListStatements;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMathRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AMinusUnaryExp;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.ANormalArrayInitialiser;
import minijava.node.ANullFactor;
import minijava.node.ANumberFactor;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.APlusUnaryExp;
import minijava.node.APostdecr;
import minijava.node.APostdecrForUnaryExp;
import minijava.node.APostfixExpUnaryExp;
import minijava.node.APostincr;
import minijava.node.APostincrForUnaryExp;
import minijava.node.APredecr;
import minijava.node.APredecrForUnaryExp;
import minijava.node.APreincr;
import minijava.node.APreincrForUnaryExp;
import minijava.node.AQualifiedName;
import minijava.node.AQualifiedNameName;
import minijava.node.AReferenceTypeType;
import minijava.node.ARelationalEquality;
import minijava.node.AReturnStatement;
import minijava.node.AScalarCommaInitList;
import minijava.node.AScalarFieldAccess;
import minijava.node.AScalarInitList;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.AStaticArrayInitialiser;
import minijava.node.AStringBasicType;
import minijava.node.AStringliteralFactor;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.ATermBoolExpression;
import minijava.node.ATermMathExpression;
import minijava.node.ATrueBooleanliteral;
import minijava.node.ATypeName;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;
import minijava.node.AUnaryForRightStat;
import minijava.node.AUnaryTerm;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AVoidBasicType;
import minijava.node.AWhileStatement;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.Start;
import minijava.node.Switch;
import minijava.node.Token;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class NodeFinder
extends DepthFirstAdapter {
    private int fStart;
    private int fEnd;
    private IDocument fDocument;
    private Node fCoveringNode;
    private Node fCoveredNode;

    protected NodeFinder(ISourceCodeLocation loc, IDocument doc) {
        this(LocationUtils.convert(loc, doc), doc);
    }

    protected NodeFinder(Position p, IDocument doc) {
        this.fDocument = doc;
        this.fStart = p.getOffset();
        this.fEnd = this.fStart + p.getLength();
    }

    public static Node perform(Start root, IDocument doc, ISourceCodeLocation location) {
        NodeFinder finder = new NodeFinder(location, doc);
        root.apply((Switch)finder);
        Node result = finder.getCoveredNode();
        if (result == null) {
            return finder.getCoveringNode();
        }
        ISourceCodeLocation foundLoc = AdvancedPositionFinder.getFullLocation(result, null);
        int comparison = SourceCodeLocationComparator.getInstance().compare(foundLoc, location);
        if (comparison != 0) {
            return finder.getCoveringNode();
        }
        return result;
    }

    public static Node perform(Start root, IDocument doc, Position pos) {
        return NodeFinder.perform(root, doc, LocationUtils.convert(pos, doc));
    }

    public void defaultCase(Node node) {
        if (this.isFlabby(node)) {
            super.defaultCase(node);
        }
    }

    public Node getCoveredNode() {
        return this.fCoveredNode;
    }

    public Node getCoveringNode() {
        return this.fCoveringNode;
    }

    private boolean isFlabby(Node node) {
        if (!(node instanceof Token)) {
            return true;
        }
        boolean flabby = true;
        try {
            ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation(node, this.fDocument);
            Position pos = LocationUtils.convert(loc, this.fDocument);
            int nodeStart = pos.getOffset();
            int nodeEnd = nodeStart + pos.getLength();
            if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
                flabby = false;
            }
            if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
                this.fCoveringNode = node;
            }
            if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
                if (this.fCoveringNode == node) {
                    this.fCoveredNode = node;
                    flabby = true;
                } else if (this.fCoveredNode == null) {
                    this.fCoveredNode = node;
                }
                flabby = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            flabby = false;
        }
        return flabby;
    }

    public void caseAAndBoolTerm(AAndBoolTerm node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAndBoolTerm(node);
        }
    }

    public void caseAArrayAccess(AArrayAccess node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayAccess(node);
        }
    }

    public void caseAArrayAllocate(AArrayAllocate node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayAllocate(node);
        }
    }

    public void caseAArrayCommaInitList(AArrayCommaInitList node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayCommaInitList(node);
        }
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayDecInnerDeclaration(node);
        }
    }

    public void caseAArrayFieldAccess(AArrayFieldAccess node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayFieldAccess(node);
        }
    }

    public void caseAArrayInit(AArrayInit node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayInit(node);
        }
    }

    public void caseAArrayInitList(AArrayInitList node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayInitList(node);
        }
    }

    public void caseAArrayIntExpression(AArrayIntExpression node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAArrayIntExpression(node);
        }
    }

    public void caseAAssertStatement(AAssertStatement node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAssertStatement(node);
        }
    }

    public void caseAAssignment(AAssignment node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAssignment(node);
        }
    }

    public void caseAAssignmentForLeftStat(AAssignmentForLeftStat node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAssignmentForLeftStat(node);
        }
    }

    public void caseAAssignmentForRightStat(AAssignmentForRightStat node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAssignmentForRightStat(node);
        }
    }

    public void caseAAssignmentStatement(AAssignmentStatement node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAAssignmentStatement(node);
        }
    }

    public void caseABasicTypeType(ABasicTypeType node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABasicTypeType(node);
        }
    }

    public void caseABlock(ABlock node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABlock(node);
        }
    }

    public void caseABlockElseFollow(ABlockElseFollow node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABlockElseFollow(node);
        }
    }

    public void caseABlockStatement(ABlockStatement node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABlockStatement(node);
        }
    }

    public void caseABooleanBasicType(ABooleanBasicType node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABooleanBasicType(node);
        }
    }

    public void caseABoolexpExpression(ABoolexpExpression node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABoolexpExpression(node);
        }
    }

    public void caseABoolliteralFactor(ABoolliteralFactor node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABoolliteralFactor(node);
        }
    }

    public void caseABreakStatement(ABreakStatement node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseABreakStatement(node);
        }
    }

    public void caseACasePossibleCase(ACasePossibleCase node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACasePossibleCase(node);
        }
    }

    public void caseACharBasicType(ACharBasicType node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACharBasicType(node);
        }
    }

    public void caseACharliteralFactor(ACharliteralFactor node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACharliteralFactor(node);
        }
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAClassDecDeclaration(node);
        }
    }

    public void caseAClassInnerDeclaration(AClassInnerDeclaration node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAClassInnerDeclaration(node);
        }
    }

    public void caseAClassTypeReferenceType(AClassTypeReferenceType node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAClassTypeReferenceType(node);
        }
    }

    public void caseAColonString(AColonString node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseAColonString(node);
        }
    }

    public void caseACommaArrayInit(ACommaArrayInit node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACommaArrayInit(node);
        }
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACommaEnumList(node);
        }
    }

    public void caseACommaExp(ACommaExp node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACommaExp(node);
        }
    }

    public void caseACommaType(ACommaType node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACommaType(node);
        }
    }

    public void caseACommaTypeName(ACommaTypeName node) {
        if (this.isFlabby((Node)node) && this.isFlabby((Node)node)) {
            super.caseACommaTypeName(node);
        }
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        if (this.isFlabby((Node)node)) {
            super.caseAConstDecDeclaration(node);
        }
    }

    public void caseADefaultPossibleCase(ADefaultPossibleCase node) {
        if (this.isFlabby((Node)node)) {
            super.caseADefaultPossibleCase(node);
        }
    }

    public void caseADivTerm(ADivTerm node) {
        if (this.isFlabby((Node)node)) {
            super.caseADivTerm(node);
        }
    }

    public void caseADNumber(ADNumber node) {
        if (this.isFlabby((Node)node)) {
            super.caseADNumber(node);
        }
    }

    public void caseADoubleBasicType(ADoubleBasicType node) {
        if (this.isFlabby((Node)node)) {
            super.caseADoubleBasicType(node);
        }
    }

    public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
        if (this.isFlabby((Node)node)) {
            super.caseADynamicArrayInitialiser(node);
        }
    }

    public void caseAElsePart(AElsePart node) {
        if (this.isFlabby((Node)node)) {
            super.caseAElsePart(node);
        }
    }

    public void caseAEmptyDeclarations(AEmptyDeclarations node) {
        super.caseAEmptyDeclarations(node);
    }

    public void caseAEmptyStatements(AEmptyStatements node) {
        super.caseAEmptyStatements(node);
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        if (this.isFlabby((Node)node)) {
            super.caseAEnumDecDeclaration(node);
        }
    }

    public void caseAEnumList(AEnumList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAEnumList(node);
        }
    }

    public void caseAEqEquality(AEqEquality node) {
        if (this.isFlabby((Node)node)) {
            super.caseAEqEquality(node);
        }
    }

    public void caseAEqualityBoolTerm(AEqualityBoolTerm node) {
        if (this.isFlabby((Node)node)) {
            super.caseAEqualityBoolTerm(node);
        }
    }

    public void caseAExpActualParamList(AExpActualParamList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAExpActualParamList(node);
        }
    }

    public void caseAExpressionFactor(AExpressionFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseAExpressionFactor(node);
        }
    }

    public void caseAFactorPostfixExp(AFactorPostfixExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFactorPostfixExp(node);
        }
    }

    public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFalseBooleanliteral(node);
        }
    }

    public void caseAFieldaccessFactor(AFieldaccessFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFieldaccessFactor(node);
        }
    }

    public void caseAFormalParamList(AFormalParamList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFormalParamList(node);
        }
    }

    public void caseAForStatement(AForStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAForStatement(node);
        }
    }

    public void caseAForUnaryStatement(AForUnaryStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAForUnaryStatement(node);
        }
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFuncDecDeclaration(node);
        }
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFunctionApplication(node);
        }
    }

    public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFunctioncallForRightStat(node);
        }
    }

    public void caseAFunctioncallStatement(AFunctioncallStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFunctioncallStatement(node);
        }
    }

    public void caseAFunctionFactor(AFunctionFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseAFunctionFactor(node);
        }
    }

    public void caseAGteqRelational(AGteqRelational node) {
        if (this.isFlabby((Node)node)) {
            super.caseAGteqRelational(node);
        }
    }

    public void caseAGtRelational(AGtRelational node) {
        if (this.isFlabby((Node)node)) {
            super.caseAGtRelational(node);
        }
    }

    public void caseAIfElseFollow(AIfElseFollow node) {
        if (this.isFlabby((Node)node)) {
            super.caseAIfElseFollow(node);
        }
    }

    public void caseAIfStat(AIfStat node) {
        if (this.isFlabby((Node)node)) {
            super.caseAIfStat(node);
        }
    }

    public void caseAIfStatement(AIfStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAIfStatement(node);
        }
    }

    public void caseAInitialiser(AInitialiser node) {
        if (this.isFlabby((Node)node)) {
            super.caseAInitialiser(node);
        }
    }

    public void caseAInnerDecForLeftStat(AInnerDecForLeftStat node) {
        if (this.isFlabby((Node)node)) {
            super.caseAInnerDecForLeftStat(node);
        }
    }

    public void caseAInnerDecStatement(AInnerDecStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAInnerDecStatement(node);
        }
    }

    public void caseAIntBasicType(AIntBasicType node) {
        if (this.isFlabby((Node)node)) {
            super.caseAIntBasicType(node);
        }
    }

    public void caseAINumber(AINumber node) {
        if (this.isFlabby((Node)node)) {
            super.caseAINumber(node);
        }
    }

    public void caseAJavaForControl(AJavaForControl node) {
        if (this.isFlabby((Node)node)) {
            super.caseAJavaForControl(node);
        }
    }

    public void caseAListActualParamList(AListActualParamList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAListActualParamList(node);
        }
    }

    public void caseAListDeclarations(AListDeclarations node) {
        if (this.isFlabby((Node)node)) {
            super.caseAListDeclarations(node);
        }
    }

    public void caseAListStatements(AListStatements node) {
        if (this.isFlabby((Node)node)) {
            super.caseAListStatements(node);
        }
    }

    public void caseALteqRelational(ALteqRelational node) {
        if (this.isFlabby((Node)node)) {
            super.caseALteqRelational(node);
        }
    }

    public void caseALtRelational(ALtRelational node) {
        if (this.isFlabby((Node)node)) {
            super.caseALtRelational(node);
        }
    }

    public void caseAMathRelational(AMathRelational node) {
        if (this.isFlabby((Node)node)) {
            super.caseAMathRelational(node);
        }
    }

    public void caseAMinusMathExpression(AMinusMathExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseAMinusMathExpression(node);
        }
    }

    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAMinusUnaryExp(node);
        }
    }

    public void caseAModTerm(AModTerm node) {
        if (this.isFlabby((Node)node)) {
            super.caseAModTerm(node);
        }
    }

    public void caseAMultTerm(AMultTerm node) {
        if (this.isFlabby((Node)node)) {
            super.caseAMultTerm(node);
        }
    }

    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseANegateUnaryExp(node);
        }
    }

    public void caseANeqEquality(ANeqEquality node) {
        if (this.isFlabby((Node)node)) {
            super.caseANeqEquality(node);
        }
    }

    public void caseANormalArrayInitialiser(ANormalArrayInitialiser node) {
        if (this.isFlabby((Node)node)) {
            super.caseANormalArrayInitialiser(node);
        }
    }

    public void caseANullFactor(ANullFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseANullFactor(node);
        }
    }

    public void caseANumberFactor(ANumberFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseANumberFactor(node);
        }
    }

    public void caseAOrBoolExpression(AOrBoolExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseAOrBoolExpression(node);
        }
    }

    public void caseAPlusMathExpression(APlusMathExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPlusMathExpression(node);
        }
    }

    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPlusUnaryExp(node);
        }
    }

    public void caseAPostdecr(APostdecr node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPostdecr(node);
        }
    }

    public void caseAPostdecrForUnaryExp(APostdecrForUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPostdecrForUnaryExp(node);
        }
    }

    public void caseAPostfixExpUnaryExp(APostfixExpUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPostfixExpUnaryExp(node);
        }
    }

    public void caseAPostincr(APostincr node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPostincr(node);
        }
    }

    public void caseAPostincrForUnaryExp(APostincrForUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPostincrForUnaryExp(node);
        }
    }

    public void caseAPredecr(APredecr node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPredecr(node);
        }
    }

    public void caseAPredecrForUnaryExp(APredecrForUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPredecrForUnaryExp(node);
        }
    }

    public void caseAPreincr(APreincr node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPreincr(node);
        }
    }

    public void caseAPreincrForUnaryExp(APreincrForUnaryExp node) {
        if (this.isFlabby((Node)node)) {
            super.caseAPreincrForUnaryExp(node);
        }
    }

    public void caseAQualifiedName(AQualifiedName node) {
        if (this.isFlabby((Node)node)) {
            super.caseAQualifiedName(node);
        }
    }

    public void caseAQualifiedNameName(AQualifiedNameName node) {
        if (this.isFlabby((Node)node)) {
            super.caseAQualifiedNameName(node);
        }
    }

    public void caseAReferenceTypeType(AReferenceTypeType node) {
        if (this.isFlabby((Node)node)) {
            super.caseAReferenceTypeType(node);
        }
    }

    public void caseARelationalEquality(ARelationalEquality node) {
        if (this.isFlabby((Node)node)) {
            super.caseARelationalEquality(node);
        }
    }

    public void caseAReturnStatement(AReturnStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAReturnStatement(node);
        }
    }

    public void caseAScalarCommaInitList(AScalarCommaInitList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAScalarCommaInitList(node);
        }
    }

    public void caseAScalarFieldAccess(AScalarFieldAccess node) {
        if (this.isFlabby((Node)node)) {
            super.caseAScalarFieldAccess(node);
        }
    }

    public void caseAScalarInitList(AScalarInitList node) {
        if (this.isFlabby((Node)node)) {
            super.caseAScalarInitList(node);
        }
    }

    public void caseASimpleName(ASimpleName node) {
        if (this.isFlabby((Node)node)) {
            super.caseASimpleName(node);
        }
    }

    public void caseASimpleNameName(ASimpleNameName node) {
        if (this.isFlabby((Node)node)) {
            super.caseASimpleNameName(node);
        }
    }

    public void caseAStaticArrayInitialiser(AStaticArrayInitialiser node) {
        if (this.isFlabby((Node)node)) {
            super.caseAStaticArrayInitialiser(node);
        }
    }

    public void caseAStringBasicType(AStringBasicType node) {
        if (this.isFlabby((Node)node)) {
            super.caseAStringBasicType(node);
        }
    }

    public void caseAStringliteralFactor(AStringliteralFactor node) {
        if (this.isFlabby((Node)node)) {
            super.caseAStringliteralFactor(node);
        }
    }

    public void caseASwitchBlock(ASwitchBlock node) {
        if (this.isFlabby((Node)node)) {
            super.caseASwitchBlock(node);
        }
    }

    public void caseASwitchStatement(ASwitchStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseASwitchStatement(node);
        }
    }

    public void caseATermBoolExpression(ATermBoolExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseATermBoolExpression(node);
        }
    }

    public void caseATermMathExpression(ATermMathExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseATermMathExpression(node);
        }
    }

    public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
        if (this.isFlabby((Node)node)) {
            super.caseATrueBooleanliteral(node);
        }
    }

    public void caseATypeName(ATypeName node) {
        if (this.isFlabby((Node)node)) {
            super.caseATypeName(node);
        }
    }

    public void caseATypeParam(ATypeParam node) {
        if (this.isFlabby((Node)node)) {
            super.caseATypeParam(node);
        }
    }

    public void caseATypeParamList(ATypeParamList node) {
        if (this.isFlabby((Node)node)) {
            super.caseATypeParamList(node);
        }
    }

    public void caseAUnaryForRightStat(AUnaryForRightStat node) {
        if (this.isFlabby((Node)node)) {
            super.caseAUnaryForRightStat(node);
        }
    }

    public void caseAUnaryTerm(AUnaryTerm node) {
        if (this.isFlabby((Node)node)) {
            super.caseAUnaryTerm(node);
        }
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        if (this.isFlabby((Node)node)) {
            super.caseAVarDecInnerDeclaration(node);
        }
    }

    public void caseAVoidBasicType(AVoidBasicType node) {
        if (this.isFlabby((Node)node)) {
            super.caseAVoidBasicType(node);
        }
    }

    public void caseAWhileStatement(AWhileStatement node) {
        if (this.isFlabby((Node)node)) {
            super.caseAWhileStatement(node);
        }
    }

    public void caseAXorBoolExpression(AXorBoolExpression node) {
        if (this.isFlabby((Node)node)) {
            super.caseAXorBoolExpression(node);
        }
    }

    public void caseStart(Start node) {
        super.caseStart(node);
    }
}

