/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.node.AEmptyStatements;
import minijava.node.AListStatements;
import minijava.node.Node;
import minijava.node.PName;
import minijava.node.PStatement;
import minijava.node.PStatements;
import minijava.node.PType;

public class NodeTools {
    protected NodeTools() {
    }

    public static ISourceCodeLocation getLocation(Node node) {
        return AdvancedPositionFinder.getFullLocation(node, null);
    }

    public static Node getParent(Node n, Class stopat) {
        Node parent = n;
        while (stopat != null && parent != null && !stopat.isInstance(parent)) {
            parent = parent.parent();
        }
        return parent;
    }

    public static Node getParent(Node n, int levels) {
        Node parent = n;
        while (levels > 0) {
            if (parent.parent() == null) {
                return parent;
            }
            parent = parent.parent();
            --levels;
        }
        return parent;
    }

    public static PName getTopMostName(PName name) {
        PName result = name;
        while (result.parent() instanceof PName) {
            result = (PName)result.parent();
        }
        return result;
    }

    public static PType getTopMostType(PType type) {
        PType result = type;
        while (result.parent() instanceof PType) {
            result = (PType)result.parent();
        }
        return result;
    }

    public static boolean limitedAreEqual(Node n1, Node n2) {
        return n1.toString().equals(n2.toString());
    }

    public static PStatement getLastStatement(PStatements statements) {
        if (statements == null || statements instanceof AEmptyStatements) {
            return null;
        }
        if (statements instanceof AListStatements) {
            AListStatements st = (AListStatements)statements;
            PStatement p = NodeTools.getLastStatement(st.getStatements());
            return p != null ? p : st.getStatement();
        }
        return null;
    }
}

