/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import java.util.ArrayList;
import java.util.List;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeFinder;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.Resolver;
import kenya.eclipse.ast.bindings.Bindings;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AFuncDecDeclaration;
import minijava.node.Node;
import minijava.node.Start;
import minijava.node.Switch;
import minijava.node.TIdentifier;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class OccurrencesFinder
extends DepthFirstAdapter {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private Start fRoot;
    private ICheckedCode fCode;
    private TIdentifier fSelectedNode;
    private IBinding fTarget;
    private List fUsages;

    public OccurrencesFinder(IBinding target) {
        this();
        this.fTarget = target;
    }

    public OccurrencesFinder() {
    }

    public String initialize(Start root, ICheckedCode code, IDocument doc, ISourceCodeLocation loc) {
        Position pos = LocationUtils.convert(loc, doc);
        return this.initialize(root, code, doc, pos.getOffset(), pos.getLength());
    }

    public String initialize(Start root, ICheckedCode code, IDocument doc, int offset, int length) {
        Node node = NodeFinder.perform(root, doc, new Position(offset, length));
        if (!(node instanceof TIdentifier)) {
            return "Cannot search for the current selection. Please select a valid Kenya element name.";
        }
        this.fCode = code;
        this.fRoot = root;
        this.fSelectedNode = (TIdentifier)node;
        this.fTarget = Resolver.resolve(this.fSelectedNode, this.fCode);
        if (this.fTarget == null) {
            return "Selected Kenya element is unknown.";
        }
        this.fUsages = new ArrayList();
        return null;
    }

    public IBinding getTarget() {
        return this.fTarget;
    }

    public String getExpandedSelectionText() {
        return NodeToString.toString((Node)this.fSelectedNode);
    }

    public List perform() {
        this.fRoot.apply((Switch)this);
        return this.fUsages;
    }

    public void caseTIdentifier(TIdentifier node) {
        this.match(node, this.fUsages, Resolver.resolve(node, this.fCode));
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        super.caseAFuncDecDeclaration(node);
    }

    private boolean match(TIdentifier node, List result, IBinding binding) {
        if (binding != null && Bindings.equals(binding, this.fTarget)) {
            result.add(node);
            return true;
        }
        return false;
    }
}

