/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.DeclarationFinder;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.Resolver;
import kenya.eclipse.ast.bindings.ClassBinding;
import kenya.eclipse.ast.bindings.EnumBinding;
import kenya.eclipse.ast.bindings.VariableBinding;
import kenya.passes.Util;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayFieldAccess;
import minijava.node.ABasicTypeType;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AIntBasicType;
import minijava.node.AQualifiedName;
import minijava.node.AQualifiedNameName;
import minijava.node.AReferenceTypeType;
import minijava.node.AScalarFieldAccess;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.ATypeName;
import minijava.node.Node;
import minijava.node.PActualParamList;
import minijava.node.PBasicType;
import minijava.node.PFieldAccess;
import minijava.node.PFormalParamList;
import minijava.node.PName;
import minijava.node.PType;
import minijava.node.Start;
import minijava.node.Switch;
import minijava.node.TIdentifier;

class ResHelper
extends DepthFirstAdapter {
    private ICheckedCode fCode;
    private Start aa;
    private IBinding fBinding;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ResHelper(ICheckedCode code) {
        this.fCode = code;
    }

    public IBinding getResolve() {
        return this.fBinding;
    }

    public void caseTIdentifier(TIdentifier node) {
        PName name;
        this.aa = (Start)NodeTools.getParent((Node)node, Integer.MAX_VALUE);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("minijava.node.PName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((name = (PName)NodeTools.getParent((Node)node, clazz)) != null) {
            name.apply((Switch)this);
        } else {
            if (NodeTools.getParent((Node)node, 1) instanceof AClassTypeReferenceType) {
                this.fBinding = DeclarationFinder.resolveClassOrEnum(node);
                return;
            }
            ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
            IFunction f = Resolver.getContainingMethod(loc, this.fCode);
            if (f != null) {
                this.fBinding = DeclarationFinder.resolveLocal(node, f);
            } else {
                AClassDecDeclaration cdec;
                loc = null;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("minijava.node.AClassDecDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cdec = (AClassDecDeclaration)NodeTools.getParent((Node)node, clazz2)) != null) {
                    int[] decloc = Util.getFirstIdent((Node)cdec.getIdentifier());
                    loc = new SourceCodeLocation(decloc[0], decloc[1], decloc[2]);
                }
                if (loc == null) {
                    AEnumDecDeclaration edec;
                    Class<?> clazz3 = class$2;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$2 = Class.forName("minijava.node.AEnumDecDeclaration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((edec = (AEnumDecDeclaration)NodeTools.getParent((Node)node, clazz3)) != null) {
                        int[] decloc = Util.getFirstIdent((Node)edec.getIdentifier());
                        loc = new SourceCodeLocation(decloc[0], decloc[1], decloc[2]);
                    }
                }
                if (loc != null) {
                    IClass cl = Resolver.getClassDefinedAt(loc, this.fCode);
                    this.fBinding = DeclarationFinder.resolveReferenceType(node, cl);
                }
                if (this.fBinding == null) {
                    this.fBinding = DeclarationFinder.resolveClassOrEnum(node);
                }
                if (this.fBinding == null) {
                    this.fBinding = DeclarationFinder.resolveBinding(node, this.aa);
                }
            }
        }
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        String name = NodeToString.toString((Node)node);
        IFunction[] funs = this.fCode.getFunctions();
        IFunction match = null;
        int i = 0;
        while (i < funs.length) {
            IFunction f = funs[i];
            if (f.getName().equals(name)) {
                if (match != null) {
                    int length2;
                    PFormalParamList l1 = node.getFormalParamList();
                    String a = NodeToString.toString((Node)l1);
                    int length = a.split(",").length;
                    if (length == (length2 = f.getArguments().length)) {
                        int matchlen = match.getArguments().length;
                        if (matchlen == length) {
                            return;
                        }
                        match = f;
                    }
                } else {
                    match = f;
                }
            }
            ++i;
        }
        this.fBinding = DeclarationFinder.resolveFunction(node.getIdentifier(), match);
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        String name = NodeToString.toString((Node)node.getName());
        ASimpleNameName snn = (ASimpleNameName)node.getName();
        ASimpleName sn = (ASimpleName)snn.getSimpleName();
        IFunction[] funs = this.fCode.getFunctions();
        IFunction match = null;
        int i = 0;
        while (i < funs.length) {
            IFunction f = funs[i];
            if (f.getName().equals(name)) {
                if (match != null) {
                    int length2;
                    PActualParamList l1 = node.getActualParamList();
                    String a = NodeToString.toString((Node)l1);
                    int length = a.split(",").length;
                    if (length == (length2 = f.getArguments().length)) {
                        int matchlen = match.getArguments().length;
                        if (matchlen == length) {
                            return;
                        }
                        match = f;
                    }
                } else {
                    match = f;
                }
            }
            ++i;
        }
        this.fBinding = DeclarationFinder.resolveFunction(sn.getIdentifier(), match);
    }

    public void caseAQualifiedName(AQualifiedName node) {
        PFieldAccess access = node.getFieldAccess();
        TIdentifier id = node.getIdentifier();
        access.apply((Switch)this);
        if (this.fBinding != null) {
            PType ptype = this.fBinding.getType();
            if (!(ptype instanceof AReferenceTypeType)) {
                if (NodeToString.toString((Node)id).equals("length")) {
                    ABasicTypeType t = new ABasicTypeType((PBasicType)new AIntBasicType());
                    this.fBinding = new VariableBinding((Node)id, this.fBinding.getDeclaringNode(), (PType)t, "");
                    return;
                }
                return;
            }
            AClassTypeReferenceType ctrt = (AClassTypeReferenceType)((AReferenceTypeType)ptype).getReferenceType();
            IBinding ceBinding = DeclarationFinder.resolveClassOrEnum(ctrt.getIdentifier());
            String name = NodeToString.toString((Node)ctrt.getIdentifier());
            IClass[] classes = ceBinding instanceof EnumBinding ? this.fCode.getEnums() : (ceBinding instanceof ClassBinding ? this.fCode.getClasses() : new IClass[]{});
            int i = 0;
            while (i < classes.length) {
                IClass c = classes[i];
                if (c.getName().equals(name)) {
                    this.fBinding = DeclarationFinder.resolveReferenceType(id, c);
                    if (this.fBinding != null) {
                        return;
                    }
                }
                ++i;
            }
        }
    }

    public void caseASimpleName(ASimpleName node) {
        PName wholeName = NodeTools.getTopMostName((PName)node.parent());
        Node immediateParent = NodeTools.getParent((Node)wholeName, 1);
        if (immediateParent instanceof AFunctionApplication || immediateParent instanceof PFieldAccess) {
            immediateParent.apply((Switch)this);
        }
    }

    public void caseAArrayFieldAccess(AArrayFieldAccess node) {
        if (node.getName() instanceof AQualifiedNameName) {
            node.getName().apply((Switch)this);
            return;
        }
        ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
        IFunction f = Resolver.getContainingMethod(loc, this.fCode);
        if (f != null) {
            IVariable variable;
            IVariable[] vars = f.getArguments();
            int j = 0;
            while (j < vars.length) {
                ATypeName name;
                variable = vars[j];
                if (variable.getName().equals(NodeToString.toString((Node)node)) && (name = Resolver.findParameter(variable.getPosition(), f.getDeclarationNode().getFormalParamList())) != null) {
                    this.fBinding = new VariableBinding((Node)node, (Node)name, name.getType(), NodeToString.toString((Node)name));
                    return;
                }
                ++j;
            }
            this.fBinding = DeclarationFinder.resolveLocal(node.getName(), f);
            if (this.fBinding != null) {
                return;
            }
            vars = this.fCode.getConstants();
            j = 0;
            while (j < vars.length) {
                variable = vars[j];
                if (variable.getName().equals(NodeToString.toString((Node)node))) {
                    this.fBinding = DeclarationFinder.resolveConstant(variable, this.fCode);
                    break;
                }
                ++j;
            }
        }
    }

    public void caseAScalarFieldAccess(AScalarFieldAccess node) {
        if (node.getName() instanceof AQualifiedNameName) {
            node.getName().apply((Switch)this);
            return;
        }
        ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
        IFunction f = Resolver.getContainingMethod(loc, this.fCode);
        if (f != null) {
            IVariable variable;
            IVariable[] vars = f.getArguments();
            int j = 0;
            while (j < vars.length) {
                ATypeName name;
                variable = vars[j];
                if (variable.getName().equals(NodeToString.toString((Node)node)) && (name = Resolver.findParameter(variable.getPosition(), f.getDeclarationNode().getFormalParamList())) != null) {
                    this.fBinding = new VariableBinding((Node)node, (Node)name, name.getType(), NodeToString.toString((Node)name));
                    return;
                }
                ++j;
            }
            this.fBinding = DeclarationFinder.resolveLocal(node.getName(), f);
            if (this.fBinding != null) {
                return;
            }
            vars = this.fCode.getConstants();
            j = 0;
            while (j < vars.length) {
                variable = vars[j];
                if (variable.getName().equals(NodeToString.toString((Node)node))) {
                    this.fBinding = DeclarationFinder.resolveConstant(variable, this.fCode);
                    break;
                }
                ++j;
            }
        }
    }
}

