/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import java.util.Iterator;
import java.util.LinkedList;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.ResHelper;
import kenya.eclipse.multieditor.kenya.util.SourceCodeLocationComparator;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.ABlock;
import minijava.node.ACommaTypeName;
import minijava.node.AFormalParamList;
import minijava.node.AQualifiedName;
import minijava.node.AQualifiedNameName;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.ATypeName;
import minijava.node.Node;
import minijava.node.PFormalParamList;
import minijava.node.PName;
import minijava.node.Switch;
import minijava.node.TIdentifier;

public class Resolver
extends DepthFirstAdapter {
    public static IBinding resolve(PName name, ICheckedCode code) {
        if (name instanceof ASimpleNameName) {
            return Resolver.resolve((ASimpleNameName)name, code);
        }
        if (name instanceof AQualifiedNameName) {
            return Resolver.resolve((AQualifiedNameName)name, code);
        }
        return null;
    }

    public static IBinding resolve(ASimpleNameName name, ICheckedCode code) {
        return Resolver.resolve((ASimpleName)name.getSimpleName(), code);
    }

    public static IBinding resolve(AQualifiedNameName name, ICheckedCode code) {
        return Resolver.resolve((AQualifiedName)name.getQualifiedName(), code);
    }

    public static IBinding resolve(AQualifiedName name, ICheckedCode code) {
        return Resolver.resolve(name.getIdentifier(), code);
    }

    public static IBinding resolve(ASimpleName name, ICheckedCode code) {
        return Resolver.resolve(name.getIdentifier(), code);
    }

    public static IBinding resolve(TIdentifier name, ICheckedCode code) {
        ResHelper w = new ResHelper(code);
        name.apply((Switch)w);
        return w.getResolve();
    }

    static ATypeName findParameter(ISourceCodeLocation loc, PFormalParamList list) {
        AFormalParamList l = (AFormalParamList)list;
        int commasize = l.getCommaTypeName() != null ? l.getCommaTypeName().size() : 0;
        ATypeName[] names = new ATypeName[commasize + 1];
        names[0] = (ATypeName)l.getTypeName();
        LinkedList ll = l.getCommaTypeName();
        int i = 1;
        Iterator iter = ll.iterator();
        while (iter.hasNext()) {
            names[i] = (ATypeName)((ACommaTypeName)iter.next()).getTypeName();
            ++i;
        }
        int j = 0;
        while (j < names.length) {
            ATypeName n = names[j];
            if (NodeTools.getLocation((Node)n.getType()).equals(loc) || NodeTools.getLocation((Node)n.getIdentifier()).equals(loc)) {
                return n;
            }
            ++j;
        }
        return null;
    }

    public static IFunction getContainingMethod(ISourceCodeLocation loc, ICheckedCode code) {
        if (code.isErroredCode()) {
            return null;
        }
        IFunction[] fs = code.getFunctions();
        int i = 0;
        while (i < fs.length) {
            boolean inside;
            IFunction f = fs[i];
            ABlock block = (ABlock)f.getDeclarationNode().getBlock();
            ISourceCodeLocation start = NodeTools.getLocation((Node)block.getLBrace());
            ISourceCodeLocation end = NodeTools.getLocation((Node)block.getRBrace());
            boolean bl = inside = SourceCodeLocationComparator.getInstance().compare(start, loc) <= 0 && SourceCodeLocationComparator.getInstance().compare(loc, end) <= 0;
            if (inside) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static IClass getClassDefinedAt(ISourceCodeLocation loc, ICheckedCode code) {
        int classes = code.getClasses().length;
        int enums = code.getEnums().length;
        IClass[] fs = new IClass[classes + enums];
        System.arraycopy(code.getClasses(), 0, fs, 0, classes);
        System.arraycopy(code.getEnums(), 0, fs, classes, enums);
        int i = 0;
        while (i < fs.length) {
            IClass f = fs[i];
            if (SourceCodeLocationComparator.getInstance().compare(f.getPosition(), loc) == 0) {
                return f;
            }
            ++i;
        }
        return null;
    }
}

