/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug;

import java.io.File;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.IProcessStreamManager;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractVKProcess
extends Process {
    public static final String VK_PROCESS_NAME = "VKProcess";
    public static final int INTERNAL_ERROR = -1;
    public static final int SUCCESS = 0;
    public static final int SUCCESS_BUT_PROGRAM_ERROR = 1;
    public static final int PREMATURE_DESTRUCTION = 102;
    public static final int STREAM_CREATION_FAILURE = 103;
    public static final int BAD_WORKING_DIRECTORY = 104;
    public static final int BAD_CODE = 105;
    private boolean finished;
    protected int returnCode = 0;
    protected File workingDirectory;
    protected String className;
    protected Job fJob;

    public AbstractVKProcess(String workDir, String className) {
        this.className = className != null ? className : "Temp";
        this.workingDirectory = new File(workDir);
        if (!(this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() || this.workingDirectory.mkdirs())) {
            KenyaPlugin.log("Launch of " + this.className + " failed:\n" + "Could not access working directory: " + workDir);
            this.finish(104);
            return;
        }
    }

    public int exitValue() {
        if (!this.hasFinished()) {
            throw new IllegalThreadStateException();
        }
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        while (!this.hasFinished()) {
            AbstractVKProcess abstractVKProcess = this;
            synchronized (abstractVKProcess) {
                this.wait();
            }
        }
        return this.exitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(int exit) {
        if (!this.finished) {
            AbstractVKProcess abstractVKProcess = this;
            synchronized (abstractVKProcess) {
                this.returnCode = exit;
                this.finished = true;
                this.notifyAll();
            }
            if (this.fJob != null) {
                this.fJob.cancel();
            }
        }
        this.dispose();
    }

    protected abstract void dispose();

    public synchronized boolean hasFinished() {
        return this.finished;
    }

    protected abstract IProcessStreamManager getStreamManager();
}

