/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug;

import java.text.DateFormat;
import java.util.Date;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.AdapterDebugTarget;
import kenya.eclipse.debug.DebugVKBridge;
import kenya.eclipse.debug.KenyaRunnerConfiguration;
import kenya.eclipse.debug.VKRunProcess;
import kenya.eclipse.debug.model.KenyaDebugModel;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.eclipse.debug.model.VKDebugProcess;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;

public class KenyaRunner {
    public KenyaRunner() {
        this.setKenyaNIOPath();
    }

    private void setKenyaNIOPath() {
        String classpath = System.getProperty("java.class.path", ".");
        String classpathSeparator = System.getProperty("path.separator");
        String cutoff = "update@";
        String loc = KenyaPlugin.getDefault().getBundle().getLocation();
        loc = loc.substring(cutoff.length());
        String nioPath = String.valueOf(loc) + "lib/KenyaNIO.jar";
        String commonPath = String.valueOf(loc) + "lib/KenyaCore.jar";
        classpath = String.valueOf(classpath) + classpathSeparator + nioPath + classpathSeparator + commonPath;
        System.setProperty("java.class.path", classpath);
    }

    public IProcess run(KenyaRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProcess p = null;
        String mode = launch.getLaunchMode();
        if ("debug".equals(mode)) {
            DebugVKBridge bridge = new DebugVKBridge();
            VKDebugProcess proc = (VKDebugProcess)KenyaDebugModel.newDebugProcess(launch, config.getWorkingDirectory(), config.getCheckedCode(), config.getArguments(), config.getStopInMain());
            p = this.newProcess(launch, proc, this.renderLabel(launch, config));
            proc.setBridge(bridge);
            KenyaDebugTarget target = new KenyaDebugTarget(launch, proc, config.getClassName(), bridge, config.getStopInMain());
            launch.addDebugTarget((IDebugTarget)target);
        } else if ("run".equals(mode)) {
            VKRunProcess proc = new VKRunProcess(config.getWorkingDirectory(), config.getJavaCode(), config.getClassName(), config.getArguments());
            p = this.newProcess(launch, proc, this.renderLabel(launch, config));
            launch.addDebugTarget((IDebugTarget)new AdapterDebugTarget(launch, proc, config.getClassName()));
        } else {
            this.abort("Unsupported launch operation: " + mode, null, 150);
        }
        return p;
    }

    private String renderLabel(ILaunch launch, KenyaRunnerConfiguration config) {
        String projectName = config.getProjectName();
        return String.valueOf(projectName) + "/" + config.getClassName() + " - " + DateFormat.getDateTimeInstance().format(new Date());
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label);
        if (process == null) {
            p.destroy();
            this.abort("KenyaRunner encountered an internal error", null, 150);
        }
        return process;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, KenyaPlugin.getPluginId(), code, message, exception));
    }
}

