/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug;

import java.io.File;
import java.util.ArrayList;
import kenya.eclipse.KenyaConventions;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.subscription.ICheckedCodeReceiver;
import mediator.subscription.IJavaCodeReceiver;
import mediator.subscription.ISubscriber;
import mediator.subscription.ISubscription;
import mediator.subscription.ISubscriptionData;
import mediator.subscription.MediationService;
import mediator.subscription.MediationSubscription;
import mediator.subscription.MediationTerms;
import mediator.subscription.MediatorInput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.Assert;

public class KenyaRunnerConfiguration {
    public static final String[] NO_ARGS = new String[0];
    public static final String KENYA_TMP = String.valueOf(System.getProperty("user.home")) + File.separatorChar + ".kenyaTmp";
    public static final String TEMP_CLASS = "TemporaryClass";
    private MediatorInput input;
    private String[] args = NO_ARGS;
    private String workingDir = KENYA_TMP;
    private String className = "TemporaryClass";
    private String projectName = "";
    private boolean stopInMain = false;

    public KenyaRunnerConfiguration(MediatorInput input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.input = input;
    }

    public void setArguments(String[] args) {
        if (args == null) {
            args = NO_ARGS;
        }
        this.args = args;
    }

    public void setArguments(String args) {
        this.setArguments(this.parseArguments(args));
    }

    protected String[] parseArguments(String pargs) {
        if (pargs == null) {
            return NO_ARGS;
        }
        StringBuffer buf = new StringBuffer(pargs.trim());
        ArrayList<String> a = new ArrayList<String>();
        while (buf.length() > 0) {
            char c = buf.charAt(0);
            if (c == '\"' && buf.indexOf("\"", 1) > 0) {
                int end = buf.indexOf("\"", 1);
                String arg = buf.substring(1, end);
                buf.delete(0, end + 1);
                a.add(arg);
                continue;
            }
            if (Character.isWhitespace(c)) {
                buf.deleteCharAt(0);
                continue;
            }
            StringBuffer arg = new StringBuffer();
            while (buf.length() > 0 && !Character.isWhitespace(buf.charAt(0))) {
                arg.append(buf.charAt(0));
                buf.deleteCharAt(0);
            }
            a.add(arg.toString());
        }
        return a.toArray(new String[0]);
    }

    public String[] getArguments() {
        return this.args;
    }

    public IJavaCode getJavaCode() {
        return this.receiveCode((MediatorInput)this.input).j;
    }

    public ICheckedCode getCheckedCode() {
        return this.receiveCode((MediatorInput)this.input).c;
    }

    protected TempCodeReceiver receiveCode(MediatorInput minput) {
        TempCodeReceiver r = new TempCodeReceiver();
        MediationTerms t = new MediationTerms(minput, (ICheckedCodeReceiver)r, (IJavaCodeReceiver)r);
        MediationSubscription s = new MediationSubscription((ISubscriber)new NullSubscriber(), t);
        String id = MediationService.getInstance().addSubscription((ISubscription)s);
        MediationService.getInstance().provideSyncSubscriptionUpdate(id);
        MediationService.getInstance().cancelSubscription(id);
        return r;
    }

    public void setClassName(String clazz) {
        IStatus st = KenyaConventions.validateKenyaTypeName(clazz);
        if (st.getSeverity() == 4) {
            clazz = TEMP_CLASS;
        }
        this.className = clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public void setWorkingDirectory(String dir) {
        if (dir == null) {
            dir = KENYA_TMP;
        } else {
            File f = new File(dir);
            if (f.isFile()) {
                dir = KENYA_TMP;
            }
        }
        this.workingDir = dir;
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setStopInMain(boolean stopInMain) {
        this.stopInMain = stopInMain;
    }

    public boolean getStopInMain() {
        return this.stopInMain;
    }

    public void setProjectName(String name) {
        this.projectName = name != null ? name : "";
    }

    public String getProjectName() {
        return this.projectName;
    }

    protected class NullSubscriber
    implements ISubscriber {
        protected NullSubscriber() {
        }

        public void subscriptionUpdate(ISubscriptionData data) {
        }
    }

    protected class TempCodeReceiver
    implements IJavaCodeReceiver,
    ICheckedCodeReceiver {
        protected IJavaCode j = null;
        protected ICheckedCode c = null;

        protected TempCodeReceiver() {
        }

        public synchronized void setJavaCode(IJavaCode code) {
            this.j = code;
        }

        public void setCheckedCode(ICheckedCode code) {
            this.c = code;
        }
    }
}

