/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class KenyaTypeSearchEngine {
    public IPath[] search(IResource[] ress) throws CoreException {
        ArrayList r = new ArrayList();
        int i = 0;
        while (i < ress.length) {
            r.addAll(this.recursiveSearch(ress[i]));
            ++i;
        }
        return r.toArray(new IPath[0]);
    }

    public IPath[] search(IResource res) throws CoreException {
        return this.recursiveSearch(res).toArray(new IPath[0]);
    }

    public IPath[] search(IContainer root) throws CoreException {
        ArrayList paths = this.recursiveSearch(root);
        return paths.toArray(new IPath[paths.size()]);
    }

    public IPath[] search(IFile file) throws CoreException {
        IPath[] iPathArray;
        if (this.isKenyaFile(file)) {
            IPath[] iPathArray2 = new IPath[1];
            iPathArray = iPathArray2;
            iPathArray2[0] = file.getFullPath();
        } else {
            iPathArray = new IPath[]{};
        }
        return iPathArray;
    }

    protected boolean isKenyaFile(IFile file) {
        return "k".equals(file.getFileExtension());
    }

    protected ArrayList recursiveSearch(IResource res) throws CoreException {
        IPath[] p;
        ArrayList<IPath> r = new ArrayList<IPath>();
        if (res instanceof IContainer) {
            return this.recursiveSearch((IContainer)res);
        }
        if (res instanceof IFile && (p = this.search((IFile)res)).length == 1) {
            r.add(p[0]);
        }
        return r;
    }

    protected ArrayList recursiveSearch(IContainer root) throws CoreException {
        IResource[] r;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        if (root instanceof IProject && !(r = (IResource[])root).hasNature("kenya.eclipse.kenyanature")) {
            return paths;
        }
        r = root.members();
        int i = 0;
        while (i < r.length) {
            IFile f;
            if (r[i] instanceof IContainer) {
                paths.addAll(this.recursiveSearch((IContainer)r[i]));
            } else if (r[i] instanceof IFile && this.isKenyaFile(f = (IFile)r[i])) {
                paths.add(f.getFullPath());
            }
            ++i;
        }
        return paths;
    }
}

