/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.AbstractVKProcess;
import kenya.eclipse.debug.IProcessStreamManager;
import mediator.IJavaCode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class VKRunProcess
extends AbstractVKProcess {
    private PipedInputStream stdInPIS;
    private PipedOutputStream stdInPOS;
    private BufferedReader stdInReader;
    private PrintWriter stdInWriter;
    private PipedInputStream stdOutPIS;
    private PipedOutputStream stdOutPOS;
    private BufferedWriter stdOutWriter;
    private PipedInputStream stdErrPIS;
    private BufferedWriter stdErrWriter;
    private IJavaCode code;
    private String[] args;
    private VKRunProcessStreamManager fStreamManager;

    public VKRunProcess(String workingDirectory, IJavaCode code, String className, String[] args) {
        super(workingDirectory, className);
        if (code == null) {
            this.finish(105);
            return;
        }
        this.code = code;
        String[] stringArray = this.args = args != null ? args : new String[]{};
        if (this.hasFinished()) {
            return;
        }
        try {
            this.stdInPOS = new PipedOutputStream();
            this.stdInPIS = new PipedInputStream(this.stdInPOS);
            this.stdInReader = new BufferedReader(new InputStreamReader(this.stdInPIS));
            this.stdInWriter = new PrintWriter(this.stdInPOS);
            this.stdOutPIS = new PipedInputStream();
            this.stdOutPOS = new PipedOutputStream(this.stdOutPIS);
            this.stdOutWriter = new BufferedWriter(new OutputStreamWriter(this.stdOutPOS));
            this.stdErrPIS = new PipedInputStream();
            this.stdErrWriter = new BufferedWriter(new OutputStreamWriter(new PipedOutputStream(this.stdErrPIS)));
        }
        catch (IOException e) {
            KenyaPlugin.log("Launch of " + className + " failed:\n" + "Could not create piped streams.", e);
            this.finish(103);
        }
        if (!this.hasFinished()) {
            this.initProcess();
        }
    }

    protected void initProcess() {
        this.fJob = new Job("VKProcess"){

            public IStatus run(IProgressMonitor monitor) {
                File[] snapshot0 = VKRunProcess.this.workingDirectory.listFiles();
                VKRunProcess.this.code.execute(VKRunProcess.this.workingDirectory.getAbsolutePath(), VKRunProcess.this.className, VKRunProcess.this.stdInReader, new BufferedWriter(VKRunProcess.this.stdInWriter), VKRunProcess.this.stdOutWriter, VKRunProcess.this.stdErrWriter, VKRunProcess.this.args);
                File[] snapshot1 = VKRunProcess.this.workingDirectory.listFiles();
                int i = 0;
                while (i < snapshot1.length) {
                    String ending;
                    String name;
                    int dotIndex;
                    File file = snapshot1[i];
                    int r = Arrays.binarySearch(snapshot0, file, new FileNameComparator());
                    if (r < 0 && (dotIndex = (name = file.getName()).lastIndexOf(46)) > 0 && ("java".equals(ending = name.substring(dotIndex)) || "class".equals(ending))) {
                        file.delete();
                    }
                    ++i;
                }
                VKRunProcess.this.finish(0);
                return Status.OK_STATUS;
            }
        };
        this.fJob.setSystem(true);
        this.fJob.schedule();
    }

    protected void dispose() {
        if (this.stdOutWriter != null) {
            try {
                this.stdOutWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (this.stdErrWriter != null) {
            try {
                this.stdErrWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (this.stdInWriter != null) {
            this.stdInWriter.close();
        }
    }

    public void destroy() {
        if (!this.hasFinished()) {
            this.code.killLastProcess();
            this.finish(102);
            this.dispose();
        }
    }

    public InputStream getErrorStream() {
        return new BufferedInputStream(this.stdErrPIS);
    }

    public InputStream getInputStream() {
        return new BufferedInputStream(this.stdOutPIS);
    }

    public OutputStream getOutputStream() {
        return new BufferedOutputStream(this.stdInPOS);
    }

    protected IProcessStreamManager getStreamManager() {
        if (this.fStreamManager == null) {
            this.fStreamManager = new VKRunProcessStreamManager();
        }
        return this.fStreamManager;
    }

    class FileNameComparator
    implements Comparator {
        FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }

        public int compare(File f1, File f2) {
            if (f1.isDirectory()) {
                if (f2.isDirectory()) {
                    return f1.getName().compareTo(f2.getName());
                }
                return 1;
            }
            if (f1.isFile()) {
                if (f2.isDirectory()) {
                    return -1;
                }
                if (f2.isFile()) {
                    return f1.getName().compareTo(f2.getName());
                }
                return 1;
            }
            return -1;
        }
    }

    class VKRunProcessStreamManager
    implements IProcessStreamManager {
        VKRunProcessStreamManager() {
        }

        public void closeInput() throws IOException {
            if (VKRunProcess.this.stdInWriter != null) {
                VKRunProcess.this.stdInWriter.close();
            }
        }

        public void closeOutput() throws IOException {
            if (VKRunProcess.this.stdOutWriter != null) {
                VKRunProcess.this.stdOutWriter.close();
            }
        }

        public void closeErr() throws IOException {
            if (VKRunProcess.this.stdErrWriter != null) {
                VKRunProcess.this.stdErrWriter.close();
            }
        }
    }
}

