/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.launcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.KenyaRunnerConfiguration;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import mediator.subscription.MediatorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Path path;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("Verifying launch attributes");
        String pgmArgs = this.getProgramArguments(configuration);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = null;
        String projName = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        proj = root.getProject(projName);
        if (proj == null) {
            this.error(100, "project invalid");
        } else if (!proj.isAccessible()) {
            this.error(124, "project is not open");
        }
        IFile main = null;
        String type = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (type == null) {
            this.error(101, "main type not specified");
        }
        if ((path = new Path(type)) == null) {
            this.error(101, "main type invalid");
        } else if (!proj.getFullPath().isPrefixOf((IPath)path)) {
            this.error(101, "main type in wrong project");
        }
        main = root.getFile((IPath)path);
        if (main == null || !main.exists()) {
            this.error(101, "main type does not exist");
        }
        String workingDir = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        boolean stopInMain = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        if (monitor.isCanceled()) {
            return;
        }
        final InputStream contents = main.getContents();
        MediatorInput input = new MediatorInput(){

            public Reader getReader() {
                return new BufferedReader(new InputStreamReader(contents));
            }
        };
        monitor.worked(1);
        monitor.worked(1);
        KenyaRunnerConfiguration c = new KenyaRunnerConfiguration(input);
        c.setArguments(pgmArgs);
        c.setWorkingDirectory(workingDir);
        c.setClassName(main.getFullPath().removeFileExtension().lastSegment());
        c.setProjectName(main.getFullPath().removeLastSegments(1).toString());
        c.setStopInMain(stopInMain);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("Launching...");
        KenyaPlugin.getDefault().getKenyaRunner().run(c, launch, monitor);
        monitor.done();
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
    }

    protected void error(int code, String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, KenyaPlugin.getPluginId(), code, message, null));
    }
}

