/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import java.util.HashMap;
import java.util.Map;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugModel;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.interpreter.util.InterpreterInspectorContentProvider;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

public class KStackFrame
extends KenyaDebugElement
implements IStackFrame,
IPointListener {
    private IThread fThread;
    private IMethodScope fScope;
    private InterpreterInspectorContentProvider inspector = new InterpreterInspectorContentProvider();
    private volatile ISourceCodeLocation fLoc;
    private volatile int offset = 0;
    private boolean fUpdateLocation;
    private String fName;
    private HashMap fVarMap = new HashMap();

    KStackFrame(KenyaDebugTarget target, IThread thread, IMethodScope scope, String name, ISourceCodeLocation loc) {
        this(target, thread, scope, name, loc, true);
    }

    KStackFrame(KenyaDebugTarget target, IThread thread, IMethodScope scope, String name, ISourceCodeLocation loc, boolean updateLocation) {
        super(target);
        this.fThread = thread;
        this.fScope = scope;
        this.fName = name;
        this.fLoc = loc;
        this.fUpdateLocation = updateLocation;
        this.reCalculateOffset();
    }

    private void reCalculateOffset() {
        try {
            String sourcePath = this.getLaunch().getLaunchConfiguration().getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            IEditorInput e = KenyaDebugModel.getModelPresentation().getEditorInput((Object)sourcePath);
            IDocument d = DocumentProviderRegistry.getDefault().getDocumentProvider(e).getDocument((Object)e);
            if (d == null) {
                return;
            }
            this.offset = d.getLineOffset(this.getLineNumber());
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (DebugException debugException) {
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        this.offset = -1;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        Object[] o = this.inspector.getChildren((Object)this.fScope);
        IVariable[] v = new KVariable[o.length];
        int i = 0;
        while (i < v.length) {
            Map.Entry key = (Map.Entry)o[i];
            KVariable var = (KVariable)((Object)this.fVarMap.get(key));
            if (var == null) {
                var = new KVariable(this.fTarget, (Map.Entry)o[i]);
                this.fVarMap.put(key, var);
            }
            v[i] = var;
            ++i;
        }
        return v;
    }

    public boolean hasVariables() throws DebugException {
        return this.inspector.hasChildren((Object)this.fScope);
    }

    public synchronized int getLineNumber() throws DebugException {
        return this.fLoc == null ? -1 : this.fLoc.getLineNumber() - 1;
    }

    public synchronized int getCharStart() throws DebugException {
        return this.fLoc == null ? -1 : (this.offset < 0 ? -1 : this.offset + this.fLoc.getColumnNumber() - 1);
    }

    public synchronized int getCharEnd() throws DebugException {
        return this.fLoc == null ? -1 : this.getCharStart() + this.fLoc.getTokenLength();
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.isSuspended() && this.isStepping();
    }

    public boolean canStepOver() {
        return this.canStepInto();
    }

    public boolean canStepReturn() {
        return this.canStepInto();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.fireResumeEvent(1);
        this.getThread().stepInto();
        this.fireSuspendEvent(8);
    }

    public void stepOver() throws DebugException {
        this.fireResumeEvent(2);
        this.getThread().stepOver();
        this.fireSuspendEvent(8);
    }

    public void stepReturn() throws DebugException {
        this.fireResumeEvent(4);
        this.getThread().stepReturn();
        this.fireSuspendEvent(8);
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.fireResumeEvent(64);
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
        this.fireSuspendEvent(32);
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
        this.fireTerminateEvent();
    }

    public synchronized void pointReached(Object data) {
        if (data instanceof ISourceCodeLocation) {
            if (!this.fUpdateLocation) {
                return;
            }
            this.fLoc = (ISourceCodeLocation)data;
            this.reCalculateOffset();
        } else {
            System.out.println("pointReached data: " + data.getClass().getName());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof KStackFrame && this.equals((KStackFrame)((Object)obj)) || super.equals(obj);
    }

    public boolean equals(KStackFrame obj) {
        try {
            return obj.fTarget == this.fTarget && obj.fThread == this.fThread && obj.fScope == this.fScope && obj.getVariables().equals(this.getVariables());
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public int hashCode() {
        return this.fScope.hashCode();
    }

    public synchronized void updateBeforeResume() {
    }
}

