/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.eclipse.debug.model.values.KValue;
import kenya.eclipse.debug.model.values.KValueFactory;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class KVariable
extends KenyaDebugElement
implements org.eclipse.debug.core.model.IVariable {
    private String internalName;
    private String presentationName;
    private IVariable fVar;
    private IType fType;
    private IClass fClass;
    private final boolean noLookup;
    private IStackMachineInformationProvider ismip;
    private Exception failure;

    public KVariable(KenyaDebugTarget target, Map.Entry entry) {
        this(target, (IType)entry.getValue(), (String)entry.getKey());
    }

    public KVariable(KenyaDebugTarget target, IType type, String iName) {
        this(target, type, iName, false);
    }

    public KVariable(KenyaDebugTarget target, String eName, IType type, IVariable var) {
        this(target, type, eName, true);
        this.fVar = var;
        this.updateFields();
        this.updateBeforeResume();
    }

    private KVariable(KenyaDebugTarget target, IType type, String name, boolean noLookup) {
        super(target);
        this.fType = type;
        this.noLookup = noLookup;
        if (noLookup) {
            this.presentationName = name;
        } else {
            this.internalName = name;
        }
        this.updateFields();
    }

    private void updateFields() {
        if (!this.noLookup) {
            try {
                if (this.ismip == null) {
                    this.ismip = this.fTarget.getStackMachineInformationProvider();
                }
                this.fVar = this.ismip.lookupVariable(this.internalName);
                if (this.fVar == null) {
                    this.failure = new NullPointerException("unable to resolve variable " + this.internalName);
                    return;
                }
                this.failure = null;
            }
            catch (InvocationTargetException e) {
                this.failure = e;
            }
        }
        if (this.fVar != null) {
            this.fClass = this.fVar.getType();
        }
    }

    public String getReferenceTypeName() throws DebugException {
        this.checkFailure();
        return this.fClass.getName();
    }

    public IValue getValue() throws DebugException {
        return KValueFactory.create(this.fTarget, this.fVar, this.fType);
    }

    public String getName() throws DebugException {
        if (this.noLookup) {
            return this.presentationName;
        }
        this.checkFailure();
        return this.fVar.getName();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this.unsupported("changing values is not supported");
    }

    public void setValue(IValue value) throws DebugException {
        this.unsupported("changing values is not supported");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        this.unsupported("changing values is not supported");
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        this.unsupported("changing values is not supported");
        return false;
    }

    private void checkFailure() throws DebugException {
        if (!this.noLookup) {
            this.updateFields();
        }
        if (this.failure != null || this.fVar == null) {
            this.abort("variable lookup failed", this.failure);
        }
    }

    public boolean isValueEqual(KVariable var) {
        try {
            boolean b = ((KValue)this.getValue()).isValueEqual((KValue)var.getValue());
            return b;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public synchronized void updateBeforeResume() {
    }
}

