/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.model.KenyaDebugModelPresentation;
import kenya.eclipse.debug.model.VKDebugProcess;
import kenya.eclipse.debug.model.breakpoints.KenyaLineBreakpoint;
import kenya.interpreter.util.InterpreterInspectorListContentProvider;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDebugModelPresentation;

public class KenyaDebugModel {
    public static final String MODEL_ID = KenyaPlugin.getPluginId();
    private static InterpreterInspectorListContentProvider inspector;
    private static IDebugModelPresentation fPresentation;

    private KenyaDebugModel() {
    }

    public static String getModelIdentifier() {
        return MODEL_ID;
    }

    public static IDebugModelPresentation getModelPresentation() {
        if (fPresentation == null) {
            fPresentation = new KenyaDebugModelPresentation();
        }
        return fPresentation;
    }

    public static Process newDebugProcess(ILaunch launch, String workingDirectory, ICheckedCode checkedCode, String[] arguments, boolean stopInMain) {
        return new VKDebugProcess(launch, workingDirectory, checkedCode, arguments, stopInMain);
    }

    public static InterpreterInspectorListContentProvider getInspectorListContentProvider() {
        if (inspector == null) {
            inspector = new InterpreterInspectorListContentProvider();
        }
        return inspector;
    }

    public static KenyaLineBreakpoint lineBreakpointExists(IResource resource, int lineNumber) throws CoreException {
        String modelId = KenyaDebugModel.getModelIdentifier();
        String markerType = KenyaLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            KenyaLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof KenyaLineBreakpoint && (marker = (breakpoint = (KenyaLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && marker.getType().equals(markerType) && marker.getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static KenyaLineBreakpoint createLineBreakpoint(IResource resource, ISourceCodeLocation location, int start, int end, boolean register) throws CoreException {
        KenyaLineBreakpoint existing = KenyaDebugModel.lineBreakpointExists(resource, location.getLineNumber());
        return existing != null ? existing : new KenyaLineBreakpoint(resource, location, start, end, register);
    }
}

