/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import kenya.eclipse.debug.AbstractVKProcess;
import kenya.eclipse.debug.AdapterDebugTarget;
import kenya.eclipse.debug.bridge.IBridgeCommunicator;
import kenya.eclipse.debug.bridge.ICommunicationBridge;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.model.KenyaDebugModel;
import kenya.eclipse.debug.model.KenyaThread;
import kenya.eclipse.debug.model.breakpoints.KenyaLineBreakpoint;
import kenya.interpreter.util.InterpreterInspectorListContentProvider;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.wellquite.kenya.stackMachine.StackMachine;

public class KenyaDebugTarget
extends AdapterDebugTarget
implements IBridgeCommunicator {
    private KenyaThread fThread;
    private IThread[] fThreads;
    private IThread[] noThreads = new IThread[0];
    private ICommunicationBridge fBridge;
    private InterpreterInspectorListContentProvider inspector;
    private HashMap fBreakpoints;
    private boolean disposed = false;

    public KenyaDebugTarget(ILaunch launch, AbstractVKProcess process, String name, ICommunicationBridge bridge, boolean stop) throws CoreException {
        super(launch, process, name);
        this.fTarget = this;
        this.installBreakPoints();
        this.setBridge(bridge);
        StackMachine sm = null;
        IStackMachineInformationProvider ismip = null;
        try {
            sm = this.getStackMachine();
            sm.setStepMode(true);
            ismip = this.getStackMachineInformationProvider();
        }
        catch (InvocationTargetException e) {
            this.abort("Could not access remote StackMachine", e);
        }
        this.inspector = KenyaDebugModel.getInspectorListContentProvider();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fThread = new KenyaThread(this, this.inspector, sm, ismip);
        this.fThreads = new IThread[]{this.fThread};
        if (!stop) {
            this.fThread.resume();
        } else {
            this.fireSuspendEvent(32);
        }
    }

    public IThread[] getThreads() throws DebugException {
        return !this.disposed ? this.fThreads : this.noThreads;
    }

    public boolean hasThreads() throws DebugException {
        return this.disposed;
    }

    public void setBridge(ICommunicationBridge bridge) {
        this.fBridge = bridge;
        this.fBridge.addPort(this);
    }

    public void removeBridge(ICommunicationBridge bridge) {
        if (this.fBridge == bridge) {
            this.fBridge = null;
        }
    }

    public ICommunicationBridge getBridge() {
        return this.fBridge;
    }

    public Object invokeRemote(String methName, Object[] args) throws InvocationTargetException {
        if (methName == null) {
            throw new InvocationTargetException(new NullPointerException("methName is null"));
        }
        return null;
    }

    protected Object invokeOnBridge(String methName, Object[] args) throws InvocationTargetException {
        if (this.fBridge == null) {
            throw new InvocationTargetException(new NullPointerException("bridge not set"));
        }
        return this.fBridge.invokeRemote(this, methName, args);
    }

    public StackMachine getStackMachine() throws InvocationTargetException {
        return (StackMachine)this.invokeOnBridge("getStackMachine", null);
    }

    public IStackMachineInformationProvider getStackMachineInformationProvider() throws InvocationTargetException {
        return (IStackMachineInformationProvider)this.invokeOnBridge("getStackMachineInformationProvider", null);
    }

    public boolean canTerminate() {
        try {
            return (Boolean)this.invokeOnBridge("canTerminate", null);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    public boolean isTerminated() {
        boolean term = false;
        try {
            term = (Boolean)this.invokeOnBridge("isTerminated", null);
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (term && !this.disposed) {
            this.dispose();
        }
        return term;
    }

    protected synchronized void dispose() {
        this.disposed = true;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fThread = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate() throws DebugException {
        try {
            try {
                this.invokeOnBridge("terminate", null);
            }
            catch (InvocationTargetException e) {
                this.abort("communication failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dispose();
            this.fireTerminateEvent();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.dispose();
        }
        this.fireTerminateEvent();
    }

    public boolean canResume() {
        return !this.disposed && this.fThread.canResume();
    }

    public boolean canSuspend() {
        return !this.disposed && this.fThread.canSuspend();
    }

    public boolean isSuspended() {
        return !this.disposed && this.fThread.isSuspended();
    }

    public void resume() throws DebugException {
        if (this.fThread != null) {
            this.fThread.resume();
        } else {
            this.abort("target has already terminated", null);
        }
    }

    public void suspend() throws DebugException {
        if (this.fThread != null) {
            this.fThread.suspend();
        } else {
            this.abort("target has already terminated", null);
        }
    }

    private void installBreakPoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] points = manager.getBreakpoints(this.getModelIdentifier());
        this.fBreakpoints = new HashMap(points.length);
        int i = 0;
        while (i < points.length) {
            IBreakpoint bp = points[i];
            if (this.supportsBreakpoint(bp)) {
                this.breakpointAdded(bp);
            }
            ++i;
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals(KenyaDebugModel.getModelIdentifier())) {
            try {
                IMarker marker;
                String program = this.getLaunch().getLaunchConfiguration().getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
                if (program != null && (marker = breakpoint.getMarker()) != null) {
                    Path p = new Path(program);
                    return marker.getResource().getFullPath().equals((Object)p);
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            KenyaLineBreakpoint lb = (KenyaLineBreakpoint)breakpoint;
            try {
                ISourceCodeLocation loc = lb.getRealLocation();
                this.fBreakpoints.put(loc, lb);
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            KenyaLineBreakpoint lb = (KenyaLineBreakpoint)breakpoint;
            try {
                ISourceCodeLocation loc = lb.getRealLocation();
                this.fBreakpoints.remove(loc);
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointAdded(breakpoint);
    }

    public boolean breakpointAt(ISourceCodeLocation loc) {
        return this.fBreakpoints != null && this.fBreakpoints.get(loc) != null;
    }
}

