/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import java.lang.reflect.Array;
import java.util.HashMap;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.model.KStackFrame;
import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.interpreter.util.InterpreterInspectorListContentProvider;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

public class KenyaThread
extends KenyaDebugElement
implements IThread {
    protected InterpreterInspectorListContentProvider fInspector;
    protected StackMachine sm;
    protected IStackMachineInformationProvider ismip;
    private HashMap frameMap = new HashMap();
    private PositionThing execListener;

    public KenyaThread(KenyaDebugTarget target, InterpreterInspectorListContentProvider inspector, StackMachine sm, IStackMachineInformationProvider ismip) {
        super(target);
        this.fInspector = inspector;
        this.sm = sm;
        this.ismip = ismip;
        this.execListener = new PositionThing();
        sm.addPositionReachedListener((IPointListener)this.execListener);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        Object[] list = this.fInspector.getElements((Object)this.sm);
        IStackFrame[] r = new KStackFrame[list.length];
        int i = 0;
        while (i < list.length) {
            IMethodScope scope = (IMethodScope)list[i];
            if (this.frameMap.containsKey(scope)) {
                r[i] = (KStackFrame)((Object)this.frameMap.get(scope));
            } else {
                r[i] = this.stackFrameFromScope(scope);
                this.frameMap.put(scope, r[i]);
            }
            if (r[i] == null) {
                this.abort("Possible shutdown in progress", null);
            }
            ++i;
        }
        return r;
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.isTerminated() && this.sm.getMethodScope() != null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IMethodScope scope = this.sm.getMethodScope();
        if (this.frameMap.containsKey(scope)) {
            return (KStackFrame)((Object)this.frameMap.get(scope));
        }
        KStackFrame frame = this.stackFrameFromScope(this.sm.getMethodScope());
        if (frame == null) {
            this.abort("possible stack machine shutdown", null);
        }
        this.frameMap.put(scope, frame);
        return frame;
    }

    public String getName() {
        return "Main";
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public boolean canResume() {
        return this.sm.canResume();
    }

    public boolean canSuspend() {
        return this.sm != null && this.sm.canSuspend();
    }

    public boolean isSuspended() {
        return this.sm != null && this.sm.canResume();
    }

    public void resume() throws DebugException {
        if (this.sm == null) {
            Status s = new Status(4, KenyaPlugin.getPluginId(), 5010, "shutting down", null);
            throw new DebugException((IStatus)s);
        }
        this.fireResumeEvent(64);
        this.sm.resume();
    }

    public void suspend() throws DebugException {
        this.suspend(32);
    }

    protected void suspend(int eventcode) {
        if (this.canSuspend()) {
            this.sm.setStepMode(true);
            this.fireSuspendEvent(eventcode);
        }
    }

    public boolean canStepInto() {
        try {
            return !this.isTerminated() && this.getTopStackFrame().canStepInto();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return !this.isTerminated() && this.getTopStackFrame().canStepOver();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            return !this.isTerminated() && this.getTopStackFrame().canStepReturn();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean isStepping() {
        return !this.isTerminated() && this.sm != null && this.sm.getStepMode();
    }

    public void stepInto() throws DebugException {
        if (this.sm == null) {
            Status s = new Status(4, KenyaPlugin.getPluginId(), 5010, "shutting down", null);
            throw new DebugException((IStatus)s);
        }
        if (this.canResume()) {
            this.fireResumeEvent(1);
            this.sm.step();
            this.fireSuspendEvent(8);
        }
    }

    public void stepOver() throws DebugException {
        if (this.sm == null) {
            Status s = new Status(4, KenyaPlugin.getPluginId(), 5010, "shutting down", null);
            throw new DebugException((IStatus)s);
        }
        if (this.canResume()) {
            KStackFrame kf = (KStackFrame)this.getTopStackFrame();
            this.execListener.waitFor(kf.getLineNumber() + 2);
            this.execListener.waitFor(kf);
            this.fireResumeEvent(2);
            this.sm.resume();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.sm == null) {
            Status s = new Status(4, KenyaPlugin.getPluginId(), 5010, "shutting down", null);
            throw new DebugException((IStatus)s);
        }
        if (this.isSuspended()) {
            IStackFrame[] frames = this.getStackFrames();
            if (Array.getLength(frames) > 1) {
                KStackFrame kf = (KStackFrame)frames[1];
                this.execListener.waitFor(kf);
                this.fireResumeEvent(4);
                this.resume();
            } else {
                this.fireResumeEvent(4);
                this.resume();
            }
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated() || this.sm == null;
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    private synchronized KStackFrame stackFrameFromScope(IMethodScope scope) {
        String name = "Stackframe";
        ISourceCodeLocation loc = null;
        StringBuffer buf = new StringBuffer();
        IInterpretedMethod method = scope.getCurrentMethod();
        if (method == null) {
            return null;
        }
        IFunction function = this.ismip.lookupFunction(method.getName());
        if (function == null) {
            return new KStackFrame(this.fTarget, this, scope, method.getName(), null, false);
        }
        loc = function.getPosition();
        buf.append(function.getName());
        buf.append("( ");
        IVariable[] vars = function.getArguments();
        int idx = 0;
        while (idx < vars.length) {
            buf.append(vars[idx].getType());
            buf.append(" ");
            buf.append(vars[idx].getName());
            buf.append(", ");
            ++idx;
        }
        if (buf.toString().endsWith(", ")) {
            buf.delete(buf.length() - ", ".length(), buf.length());
        }
        buf.append(" )");
        name = buf.toString();
        KStackFrame f = new KStackFrame(this.fTarget, this, scope, name, loc);
        return f;
    }

    boolean breakPointAt(ISourceCodeLocation loc) {
        return this.fTarget.breakpointAt(loc);
    }

    protected synchronized void updateBeforeResume() {
        try {
            if (this.hasStackFrames()) {
                KStackFrame[] frames = (KStackFrame[])this.getStackFrames();
                int i = 0;
                while (i < frames.length) {
                    frames[i].updateBeforeResume();
                    ++i;
                }
            }
        }
        catch (DebugException debugException) {}
    }

    class PositionThing
    implements IPointListener {
        private int waitfor_line = -1;
        private IStackFrame waitfor_frame = null;

        PositionThing() {
        }

        public void waitFor(int line) {
            this.waitfor_line = line;
        }

        public void waitFor(IStackFrame frame) {
            this.waitfor_frame = frame;
        }

        public void pointReached(Object data) {
            if (data instanceof ISourceCodeLocation) {
                ISourceCodeLocation loc = (ISourceCodeLocation)data;
                try {
                    ((KStackFrame)KenyaThread.this.getTopStackFrame()).pointReached(loc);
                }
                catch (Exception exception) {}
                if (KenyaThread.this.breakPointAt(loc)) {
                    KenyaThread.this.suspend(16);
                    this.waitfor_line = -1;
                    this.waitfor_frame = null;
                } else if (this.waitfor_frame != null) {
                    try {
                        if (this.waitfor_frame == KenyaThread.this.getTopStackFrame() && (this.waitfor_line == -1 || loc.getLineNumber() >= this.waitfor_line)) {
                            KenyaThread.this.suspend(8);
                            this.waitfor_line = -1;
                            this.waitfor_frame = null;
                        }
                    }
                    catch (DebugException debugException) {}
                } else if (KenyaThread.this.isStepping()) {
                    KenyaThread.this.suspend(8);
                    this.waitfor_line = -1;
                    this.waitfor_frame = null;
                }
            }
        }
    }
}

