/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.AbstractVKProcess;
import kenya.eclipse.debug.IProcessStreamManager;
import kenya.eclipse.debug.KenyaRemote;
import kenya.eclipse.debug.bridge.ICommunicationBridge;
import kenya.interpreter.util.InterpreterLastPointReachedCatcher;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class VKDebugProcess
extends AbstractVKProcess
implements KenyaRemote {
    private PipedInputStream stdInPIS;
    private PipedOutputStream stdInPOS;
    private InputStream inStream;
    private BufferedOutputStream bufferedIn;
    private PipedInputStream stdOutPIS;
    private PipedOutputStream stdOutPOS;
    private PrintStream outStream;
    private BufferedInputStream bufferedOut;
    private PipedInputStream stdErrPIS;
    private PipedOutputStream stdErrPOS;
    private PrintStream errStream;
    private BufferedInputStream bufferedErr;
    private StackMachine sm;
    private IStackMachineInformationProvider ismip;
    private ICommunicationBridge fBridge;
    private VKDebugProcessStreamManager fStreamManager;

    VKDebugProcess(ILaunch launch, String workingDirectory, ICheckedCode code, final String[] args, final boolean stopInMain) {
        super(workingDirectory, code.getBaseStackMachine().getEntryPointClass().getName());
        if (code == null || code.isErroredCode()) {
            this.finish(105);
            return;
        }
        if (this.hasFinished()) {
            return;
        }
        this.getStackMachine();
        this.ismip = code.getBaseStackMachine();
        try {
            ClosureScope scope = new ClosureScope();
            ClosureMiscHelper.executeClosureInScope((IClosureScope)scope, (IAtomicClosure)this.ismip.getPreInitClosure(), (StackMachine)this.sm);
        }
        catch (Throwable t) {
            KenyaPlugin.log(t);
        }
        try {
            this.stdInPOS = new PipedOutputStream();
            this.stdInPIS = new PipedInputStream(this.stdInPOS);
            this.inStream = new BufferedInputStream(this.stdInPIS);
            this.bufferedIn = new BufferedOutputStream(this.stdInPOS);
            this.stdOutPIS = new PipedInputStream();
            this.stdOutPOS = new PipedOutputStream(this.stdOutPIS);
            this.outStream = new PrintStream(this.stdOutPOS, true);
            this.bufferedOut = new BufferedInputStream(this.stdOutPIS);
            this.stdErrPIS = new PipedInputStream();
            this.stdErrPOS = new PipedOutputStream(this.stdErrPIS);
            this.errStream = new PrintStream(this.stdErrPOS, true);
            this.bufferedErr = new BufferedInputStream(this.stdErrPIS);
            this.sm.setOut(this.outStream);
            this.sm.setErr(this.errStream);
            this.sm.setIn(this.inStream);
        }
        catch (IOException e) {
            KenyaPlugin.log("Launch of " + this.className + " failed:\n" + "Could not create piped streams.", e);
            this.finish(103);
        }
        if (!this.hasFinished()) {
            this.fJob = new Job("VKProcess"){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask("run", 1);
                        IInterpretedClass launchClass = VKDebugProcess.this.ismip.getEntryPointClass();
                        String launchMethod = VKDebugProcess.this.ismip.getEntryPoint();
                        InterpreterLastPointReachedCatcher ilprc = new InterpreterLastPointReachedCatcher(VKDebugProcess.this.sm);
                        VKDebugProcess.this.sm.addPositionReachedListener((IPointListener)ilprc);
                        if (monitor.isCanceled()) {
                            VKDebugProcess.this.finish(102);
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            if (VKDebugProcess.this.ismip.entryPointTakesArguments()) {
                                String[] argsString = args;
                                IType[] argsIType = new IType[argsString.length];
                                int idx = 0;
                                while (idx < argsString.length) {
                                    argsIType[idx] = StringTypeFactory.createStringType((String)argsString[idx]);
                                    ++idx;
                                }
                                VKDebugProcess.this.sm.push((IType)ArrayTypeFactory.createArrayType((IType[])argsIType, (String)"String"));
                            }
                            VKDebugProcess.this.sm.setStepMode(stopInMain);
                            VKDebugProcess.this.sm.setStepMode(true);
                            VKDebugProcess.this.sm.invokeMethod(launchClass, launchMethod);
                        }
                        catch (Throwable t) {
                            try {
                                VKDebugProcess.this.sm.shutdown();
                            }
                            catch (Exception exception) {}
                            IAtomicClosure lastClosure = ilprc.getLastClosure();
                            ISourceCodeLocation loc = (ISourceCodeLocation)ilprc.getLastPointData();
                            if (loc == null || lastClosure == null) {
                                VKDebugProcess.this.errStream.println(t);
                            } else {
                                VKDebugProcess.this.errStream.println(t + " at " + " line " + loc.getLineNumber() + ", column " + loc.getColumnNumber());
                            }
                            VKDebugProcess.this.finish(1);
                        }
                    }
                    catch (Throwable e) {
                        KenyaPlugin.log(e);
                        VKDebugProcess.this.finish(-1);
                        return new Status(4, KenyaPlugin.getPluginId(), -1, "", e);
                    }
                    monitor.worked(1);
                    VKDebugProcess.this.finish(0);
                    return Status.OK_STATUS;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.schedule();
        }
    }

    protected void dispose() {
        if (this.outStream != null) {
            this.outStream.close();
        }
        if (this.errStream != null) {
            this.errStream.close();
        }
        try {
            this.inStream.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (this.sm != null) {
            this.sm.shutdown();
            this.sm = null;
        }
    }

    public void destroy() {
        if (!this.hasFinished()) {
            if (this.sm != null) {
                this.sm.shutdown();
            }
            this.finish(102);
        }
    }

    public InputStream getErrorStream() {
        return this.bufferedErr;
    }

    public InputStream getInputStream() {
        return this.bufferedOut;
    }

    public OutputStream getOutputStream() {
        return this.bufferedIn;
    }

    public StackMachine getStackMachine() {
        if (this.sm == null) {
            this.sm = new StackMachine();
        }
        return this.sm;
    }

    public IStackMachineInformationProvider getStackMachineInformationProvider() {
        return this.ismip;
    }

    public void setBridge(ICommunicationBridge bridge) {
        this.fBridge = bridge;
        this.fBridge.addPort(this);
    }

    public void removeBridge(ICommunicationBridge bridge) {
        if (bridge == this.fBridge) {
            this.fBridge = null;
        }
    }

    public ICommunicationBridge getBridge() {
        return this.fBridge;
    }

    public Object invokeRemote(String methName, Object[] args) throws InvocationTargetException {
        if ("getStackMachine".equals(methName)) {
            return this.getStackMachine();
        }
        if ("getStackMachineInformationProvider".equals(methName)) {
            return this.getStackMachineInformationProvider();
        }
        if ("canTerminate".equals(methName)) {
            return this.canTerminate();
        }
        if ("isTerminated".equals(methName)) {
            return this.isTerminated();
        }
        if ("terminate".equals(methName)) {
            this.terminate();
            return null;
        }
        throw new InvocationTargetException(new NoSuchMethodException("method '" + methName + "' does not exist"));
    }

    public boolean canTerminate() {
        return !this.hasFinished();
    }

    public boolean isTerminated() {
        return this.hasFinished();
    }

    public void terminate() {
        this.destroy();
    }

    protected IProcessStreamManager getStreamManager() {
        if (this.fStreamManager == null) {
            this.fStreamManager = new VKDebugProcessStreamManager();
        }
        return this.fStreamManager;
    }

    class VKDebugProcessStreamManager
    implements IProcessStreamManager {
        VKDebugProcessStreamManager() {
        }

        public void closeInput() throws IOException {
            IOException ee = null;
            try {
                if (VKDebugProcess.this.inStream != null) {
                    VKDebugProcess.this.inStream.close();
                }
            }
            catch (IOException e) {
                ee = e;
            }
            if (VKDebugProcess.this.bufferedIn != null) {
                VKDebugProcess.this.bufferedIn.close();
            }
            if (ee != null) {
                throw ee;
            }
        }

        public void closeOutput() throws IOException {
            if (VKDebugProcess.this.outStream != null) {
                VKDebugProcess.this.outStream.close();
            }
            if (VKDebugProcess.this.bufferedOut != null) {
                VKDebugProcess.this.bufferedOut.close();
            }
        }

        public void closeErr() throws IOException {
            if (VKDebugProcess.this.errStream != null) {
                VKDebugProcess.this.errStream.close();
            }
            if (VKDebugProcess.this.bufferedErr != null) {
                VKDebugProcess.this.bufferedErr.close();
            }
        }
    }
}

