/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model.breakpoints;

import java.util.HashMap;
import kenya.eclipse.debug.model.KenyaDebugModel;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class KenyaLineBreakpoint
extends LineBreakpoint {
    protected static final String PROP_PREF = "_KenyaLineBreakPoint.";
    protected static final String REAL_LINE = "real_line";
    protected static final String REAL_COL = "real_column";
    protected static final String REAL_LEN = "real_length";

    public KenyaLineBreakpoint() {
    }

    public KenyaLineBreakpoint(final IResource resource, final ISourceCodeLocation location, final int charStart, final int charEnd, final boolean register) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                KenyaLineBreakpoint.this.setMarker(resource.createMarker(KenyaLineBreakpoint.getMarkerType()));
                HashMap<String, Object> attributes = new HashMap<String, Object>(8);
                int lineNumber = location.getLineNumber();
                attributes.put("org.eclipse.debug.core.id", KenyaLineBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", new Integer(lineNumber));
                attributes.put("charStart", new Integer(charStart));
                attributes.put("charEnd", new Integer(charEnd));
                attributes.put(KenyaLineBreakpoint.REAL_LINE, new Integer(location.getLineNumber()));
                attributes.put(KenyaLineBreakpoint.REAL_COL, new Integer(location.getColumnNumber()));
                attributes.put(KenyaLineBreakpoint.REAL_LEN, new Integer(location.getTokenLength()));
                KenyaLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                KenyaLineBreakpoint.this.register(register);
            }
        };
        this.run(null, wr);
    }

    public String getModelIdentifier() {
        return KenyaDebugModel.getModelIdentifier();
    }

    public static String getMarkerType() {
        return "kenya.eclipse.kenyaBreakpointMarker";
    }

    public ISourceCodeLocation getRealLocation() throws CoreException {
        int line = this.getRealLineNumber();
        int col = this.getRealColumnNumber();
        int len = this.getRealLength();
        return new SourceCodeLocation(line, col, len);
    }

    public int getRealLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute(REAL_LINE, this.getLineNumber());
    }

    public int getRealColumnNumber() throws CoreException {
        return this.ensureMarker().getAttribute(REAL_COL, 0);
    }

    public int getRealLength() throws CoreException {
        return this.ensureMarker().getAttribute(REAL_LEN, this.getCharStart() - this.getCharEnd());
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void run(ISchedulingRule rule, IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }
}

