/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model.breakpoints;

import java.util.List;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.model.KenyaDebugModel;
import kenya.eclipse.debug.model.breakpoints.KenyaLineBreakpoint;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && KenyaPlugin.getActiveWorkbenchShell() != null) {
            KenyaPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        block18: {
            if (selection instanceof ITextSelection) {
                ICheckedCode code;
                this.report(null, part);
                IEditorPart editorPart = (IEditorPart)part;
                ITextSelection textSelection = (ITextSelection)selection;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mediator.ICheckedCode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((code = (ICheckedCode)editorPart.getAdapter((Class)clazz)) == null) {
                    this.report("Setting a breakpoint is currently not possible", part);
                    return;
                }
                IEditorInput editorInput = editorPart.getEditorInput();
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDocument document = ((ITextEditor)editorPart.getAdapter((Class)clazz2)).getDocumentProvider().getDocument((Object)editorInput);
                try {
                    IStackMachineInformationProvider smip = code.getBaseStackMachine();
                    if (smip == null) break block18;
                    int lineNumber = textSelection.getStartLine() + 1;
                    int offset = textSelection.getOffset();
                    List positions = smip.getDiscreteExecutionPointMarkersFromTheAST();
                    int realOffset = 0;
                    ISourceCodeLocation realLoc = null;
                    int delta = Integer.MAX_VALUE;
                    int idx = 0;
                    while (idx < positions.size()) {
                        ISourceCodeLocation scl = (ISourceCodeLocation)positions.get(idx);
                        int thisOffset = document.getLineOffset(scl.getLineNumber() - 1) + scl.getColumnNumber() - 1;
                        int newDelta = thisOffset - offset;
                        if (newDelta >= 0 && newDelta < delta) {
                            realOffset = thisOffset;
                            realLoc = scl;
                            delta = newDelta;
                        }
                        ++idx;
                    }
                    try {
                        Object resource = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : ResourcesPlugin.getWorkspace().getRoot();
                        KenyaLineBreakpoint existingBreakpoint = KenyaDebugModel.lineBreakpointExists((IResource)resource, lineNumber);
                        if (existingBreakpoint != null) {
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                            return;
                        }
                        int e = realOffset + realLoc.getTokenLength();
                        KenyaDebugModel.createLineBreakpoint((IResource)resource, realLoc, realOffset, e, true);
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (BadLocationException e) {
                    KenyaPlugin.log(e);
                }
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        Object resource = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : ResourcesPlugin.getWorkspace().getRoot();
        return resource;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

