/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model.values;

import java.util.HashMap;
import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.eclipse.debug.model.values.KValue;
import kenya.sourceCodeInformation.interfaces.IVariable;
import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class KArrayValue
extends KValue {
    private HashMap fVarMap = new HashMap();

    KArrayValue(KenyaDebugTarget target, IVariable var, IArrayType type) {
        super(target, var);
        this.fType = type;
    }

    public String getValueString() throws DebugException {
        StringBuffer b = new StringBuffer(this.fType.getTypeName());
        return b.insert(b.length() - 1, ((IArrayType)this.fType).getLength()).toString();
    }

    public org.eclipse.debug.core.model.IVariable[] getVariables() throws DebugException {
        IType[] t = ((IArrayType)this.fType).getValue();
        org.eclipse.debug.core.model.IVariable[] v = new KVariable[t.length];
        int i = 0;
        while (i < t.length) {
            String key = "[" + i + "]";
            v[i] = (KVariable)((Object)this.fVarMap.get(key));
            if (v[i] == null) {
                v[i] = new KVariable(this.fTarget, key, t[i], this.fVar);
                this.fVarMap.put(key, v[i]);
            }
            ++i;
        }
        return v;
    }

    public boolean hasVariables() throws DebugException {
        return ((IArrayType)this.fType).getLength() > 0;
    }

    public boolean equals(KValue obj) {
        try {
            boolean b = obj.getReferenceTypeName().equals(this.getReferenceTypeName());
            b &= obj.fVar == this.fVar;
            b &= obj.getValueString().equals(this.getValueString());
            return b &= ((IArrayType)((KArrayValue)obj).fType).getLength() == ((IArrayType)this.fType).getLength();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode() + ((IArrayType)this.fType).getLength();
    }

    public boolean isValueEqual(KValue val) {
        try {
            if (val instanceof KArrayValue) {
                KArrayValue v = (KArrayValue)val;
                boolean eq = ((IArrayType)v.fType).getLength() == ((IArrayType)this.fType).getLength();
                KVariable[] vvars = (KVariable[])v.getVariables();
                KVariable[] vars = (KVariable[])this.getVariables();
                int i = 0;
                while (i < vvars.length) {
                    eq &= vvars[i].isValueEqual(vars[i]);
                    ++i;
                }
                return eq;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    public Object clone() {
        KArrayValue v = (KArrayValue)super.clone();
        v.fVarMap = this.fVarMap;
        return v;
    }
}

