/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model.values;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.eclipse.debug.model.values.KValue;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;

public class KClassValue
extends KValue {
    private HashMap fVarMap = new HashMap();

    KClassValue(KenyaDebugTarget target, IVariable var, IClassInstanceType type) {
        super(target, var);
        this.fType = type;
    }

    public String getValueString() throws DebugException {
        IStackMachineInformationProvider ismip = null;
        try {
            ismip = this.fTarget.getStackMachineInformationProvider();
        }
        catch (InvocationTargetException invocationTargetException) {
            return ((IClassInstanceType)this.fType).getValueClassName();
        }
        IInterpretedClass c = ((IClassInstanceType)this.fType).getValue().getInterpretedClass();
        String name = ismip.lookupClass(c.getName()).getName();
        return name;
    }

    public org.eclipse.debug.core.model.IVariable[] getVariables() throws DebugException {
        IInterpretedClassInstance c = ((IClassInstanceType)this.fType).getValue();
        HashSet entries = new HashSet();
        entries.addAll(c.getImmutableInstanceVariables().entrySet());
        entries.addAll(c.getMutableInstanceVariables().entrySet());
        org.eclipse.debug.core.model.IVariable[] v = new KVariable[entries.size()];
        int i = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            v[i] = (KVariable)((Object)this.fVarMap.get(e));
            if (v[i] == null) {
                v[i] = new KVariable(this.fTarget, e);
                this.fVarMap.put(e, v[i]);
            }
            ++i;
        }
        return v;
    }

    public boolean hasVariables() throws DebugException {
        IInterpretedClassInstance c = ((IClassInstanceType)this.fType).getValue();
        return c.getImmutableInstanceVariables().size() > 0 || c.getMutableInstanceVariables().size() > 0;
    }

    public boolean isValueEqual(KValue val) {
        try {
            if (val instanceof KClassValue) {
                KVariable[] vars;
                KClassValue v = (KClassValue)val;
                boolean eq = v.fType.getTypeName().equals(this.fType.getTypeName());
                KVariable[] vvars = (KVariable[])v.getVariables();
                if (vvars.length != (vars = (KVariable[])this.getVariables()).length) {
                    return false;
                }
                int i = 0;
                while (i < vvars.length) {
                    eq &= vvars[i].isValueEqual(vars[i]);
                    ++i;
                }
                return eq;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    public Object clone() {
        KClassValue v = (KClassValue)super.clone();
        v.fVarMap = this.fVarMap;
        return v;
    }
}

