/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.eclipse.debug.model.values.KValueFactory;
import kenya.sourceCodeInformation.interfaces.IVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public abstract class KValue
extends KenyaDebugElement
implements IValue,
Cloneable {
    protected IVariable fVar;
    protected IType fType;

    public KValue(KenyaDebugTarget target, IVariable var) {
        super(target);
        this.fVar = var;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fVar.getType().getName();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && (obj instanceof KValue && this.equals((KValue)obj) || super.equals(obj));
    }

    public boolean equals(KValue obj) {
        try {
            return obj.getClass().equals(this.getClass()) && obj.getReferenceTypeName().equals(this.getReferenceTypeName()) && obj.fVar == this.fVar && this.isValueEqual(obj) && obj.getVariables().equals(this.getVariables());
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public abstract boolean isValueEqual(KValue var1);

    public int hashCode() {
        int pos = this.fVar.getPosition().hashCode();
        return pos + this.fVar.getName().hashCode();
    }

    public Object clone() {
        KValue v;
        try {
            v = (KValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            v = KValueFactory.create(this.fTarget, this.fVar, this.fType);
        }
        try {
            v.fType = (IType)this.fType.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return v;
    }
}

