/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.ui.launchconfig;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.ui.launchconfig.KenyaLaunchConfigurationTab;
import kenya.eclipse.debug.ui.launcher.WorkingDirectoryBlock;
import kenya.eclipse.ui.KenyaImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ArgumentsTab
extends KenyaLaunchConfigurationTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = this.createWorkingDirBlock();

    protected WorkingDirectoryBlock createWorkingDirBlock() {
        return new WorkingDirectoryBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, parent.getStyle());
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.setHelpContextId();
        Group group = new Group(comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = "Program &arguments:";
        group.setText(controlName);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, "Va&riables...", null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ArgumentsTab.this.fPrgmArgumentsText.append(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void setHelpContextId() {
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        this.fWorkingDirectoryBlock.setDefaults(config);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading configuration:" + e.getStatus().getMessage());
            KenyaPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return "Arguments";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return KenyaImages.getImage("kenya.eclipse.variable_tab.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

