/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.ui.launchconfig;

import java.text.MessageFormat;
import java.util.ArrayList;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.KenyaTypeSearchEngine;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.ui.launchconfig.KenyaLaunchConfigurationTab;
import kenya.eclipse.debug.ui.launcher.TypeSelectionDialog;
import kenya.eclipse.ui.KenyaImages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MainTab
extends KenyaLaunchConfigurationTab {
    protected Text fProjText;
    protected Button fProjButton;
    protected Text fMainText;
    protected Button fSearchButton;
    protected Button fStopInMainCheckButton;
    protected IPath fMainPath;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        Label projLabel = new Label(comp, 0);
        projLabel.setText("Project:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        projLabel.setLayoutData((Object)gd);
        projLabel.setFont(font);
        this.fProjText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton(comp, "Browse...", null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fListener);
        this.createVerticalSpacer(comp, 2);
        this.createMainTypeEditor(comp);
        this.createVerticalSpacer(comp, 2);
        this.fStopInMainCheckButton = this.createCheckButton(comp, "Stop in main");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fStopInMainCheckButton.setLayoutData((Object)gd);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createMainTypeEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText("Kenya Type:");
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fMainText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener((ModifyListener)this.fListener);
        this.fSearchButton = this.createPushButton((Composite)mainGroup, "Search...", null);
        this.fSearchButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            KenyaPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = "";
        try {
            mainTypeName = config.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        }
        catch (CoreException ce) {
            KenyaPlugin.log(ce);
        }
        if ("".equals(mainTypeName)) {
            this.fMainPath = null;
        } else {
            this.fMainPath = new Path(mainTypeName);
            mainTypeName = this.fMainPath.removeFileExtension().lastSegment();
            this.fMainPath = this.getWorkspaceRoot().getFile(this.fMainPath).getFullPath();
        }
        this.fMainText.setText(mainTypeName);
    }

    protected void updateStopInMainFromConfig(ILaunchConfiguration configuration) {
        boolean stop = false;
        try {
            stop = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException e) {
            KenyaPlugin.log(e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainPath == null ? null : this.fMainPath.toString());
        config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, this.fStopInMainCheckButton.getSelection());
    }

    public void dispose() {
    }

    protected void handleSearchButtonSelected() {
        IProject project = this.getKenyaProject();
        if (project == null) {
            project = this.getWorkspaceRoot();
        }
        KenyaTypeSearchEngine engine = new KenyaTypeSearchEngine();
        IPath[] types = null;
        try {
            types = engine.search((IContainer)project);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        Shell shell = this.getShell();
        TypeSelectionDialog dialog = new TypeSelectionDialog(shell, types);
        dialog.setTitle("Choose main type");
        dialog.setMessage("Choose a main type and stuff");
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        this.fMainPath = (IPath)results[0];
        if (this.fMainPath != null) {
            project = this.getWorkspaceRoot().getProject(this.fMainPath.segment(0));
            this.fProjText.setText(project.getName());
            this.fMainPath = this.getWorkspaceRoot().getFile(this.fMainPath).getFullPath();
            this.fMainText.setText(this.fMainPath.removeFileExtension().lastSegment());
        }
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.fProjText.setText(projectName);
    }

    protected IProject chooseProject() {
        Object[] projects = new IProject[]{};
        try {
            IResource[] r = this.getWorkspaceRoot().members();
            ArrayList<IResource> l = new ArrayList<IResource>(r.length);
            int i = 0;
            while (i < r.length) {
                if (((IProject)r[i]).hasNature("kenya.eclipse.kenyanature")) {
                    l.add(r[i]);
                }
                ++i;
            }
            projects = l.toArray(projects);
        }
        catch (CoreException e) {
            KenyaPlugin.log(e);
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Select a project");
        dialog.setMessage("Select the project that contains the program you wish to launch");
        dialog.setElements(projects);
        IProject kenyaProject = this.getKenyaProject();
        if (kenyaProject != null) {
            dialog.setInitialSelections(new Object[]{kenyaProject});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject getKenyaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format("Project {0} does not exist", name));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format("Project {0} is closed", name));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format("Illegal project name: {0}", status.getMessage()));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage("Main type not specified");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IResource javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeKenyaProject(javaElement, config);
        } else {
            config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    protected void initializeMainTypeAndName(IResource mainType, ILaunchConfigurationWorkingCopy config) {
        IPath path = mainType != null ? mainType.getFullPath() : null;
        String name = path != null ? path.removeFileExtension().lastSegment() : "";
        String pathString = path != null ? path.toString() : "";
        config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, pathString);
        if (name.length() > 0) {
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return KenyaImages.getImage("kenya.eclipse.class_obj.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            MainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == MainTab.this.fProjButton) {
                MainTab.this.handleProjectButtonSelected();
            } else if (source == MainTab.this.fSearchButton) {
                MainTab.this.handleSearchButtonSelected();
            } else {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

