/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.KenyaTypeSearchEngine;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.ui.launcher.TypeSelectionDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class KenyaApplicationLaunchShortcut
implements ILaunchShortcut {
    public static final String NO_MAIN_IN_EDITOR = "The active editor does not contain a Kenya application.";
    public static final String NO_MAIN_IN_SELECTION = "The selection does not contain a Kenya application.";
    public static final String LAUNCH_FAILED = "Launch failed...";
    public static final String LAUNCH_ERROR = "An error occurred while launching...";
    public static final String SELECT_DEBUG = "Select the Kenya type to debug:";
    public static final String SELECT_RUN = "Select the Kenya type to run:";

    public void searchAndLaunch(IResource[] search, String mode, boolean editor) {
        IPath[] types = null;
        if (search != null) {
            try {
                KenyaTypeSearchEngine engine = new KenyaTypeSearchEngine();
                types = engine.search(search);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)LAUNCH_FAILED, (String)e.getMessage());
            }
            IPath type = null;
            if (types.length == 0) {
                String message = null;
                message = editor ? NO_MAIN_IN_EDITOR : NO_MAIN_IN_SELECTION;
                MessageDialog.openError((Shell)this.getShell(), (String)LAUNCH_FAILED, (String)message);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    protected IPath chooseType(IPath[] types, String mode) {
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), types);
        if (mode.equals("debug")) {
            dialog.setTitle(SELECT_DEBUG);
        } else {
            dialog.setTitle(SELECT_RUN);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IPath)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IPath type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IPath type, String mode) {
        ILaunchConfigurationType configType = this.getKenyaLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.makeAbsolute().toOSString()) && config.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.makeRelative().uptoSegment(1).toString())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            KenyaPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select a launch configuration");
        if (mode.equals("debug")) {
            dialog.setMessage(SELECT_DEBUG);
        } else {
            dialog.setMessage(SELECT_RUN);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IPath type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getKenyaLaunchConfigType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.removeFileExtension().lastSegment()));
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.makeAbsolute().toOSString());
        wc.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.makeRelative().uptoSegment(1).toString());
        try {
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected void reportCreatingConfiguration(final CoreException exception) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)KenyaApplicationLaunchShortcut.this.getShell(), (String)KenyaApplicationLaunchShortcut.LAUNCH_ERROR, (String)"Exception in KenyaApplicationLaunchShortcut", (IStatus)exception.getStatus());
            }
        });
    }

    protected ILaunchConfigurationType getKenyaLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IKenyaLaunchConfigurationConstants.ID_KENYA_APPLICATION);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return KenyaPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile r = null;
        if (input instanceof IFileEditorInput) {
            r = ((IFileEditorInput)input).getFile();
        }
        if (r != null) {
            this.searchAndLaunch(new IResource[]{r}, mode, true);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LAUNCH_FAILED, (String)NO_MAIN_IN_EDITOR);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toList().toArray(new IResource[0]), mode, false);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LAUNCH_FAILED, (String)NO_MAIN_IN_SELECTION);
        }
    }
}

