/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.buildext.AbstractKenyaPostBuildAnalyser;
import kenya.eclipse.buildext.IKenyaPostBuildAnalyserFactory;
import kenya.eclipse.multieditor.AdaptedMultiPageEditorSite;
import kenya.eclipse.multieditor.java.JavaEditor;
import kenya.eclipse.multieditor.kenya.KenyaEditor;
import kenya.eclipse.multieditor.util.GeneratedJava;
import kenya.eclipse.multieditor.util.GeneratedJavaInput;
import kenya.eclipse.multieditor.util.KenyaHelperThread;
import kenya.ui.UIUtils;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.subscription.ICheckedCodeReceiver;
import mediator.subscription.IJavaCodeReceiver;
import mediator.subscription.ISubscriber;
import mediator.subscription.ISubscription;
import mediator.subscription.ISubscriptionData;
import mediator.subscription.MediationService;
import mediator.subscription.MediationSubscription;
import mediator.subscription.MediationTerms;
import mediator.subscription.MediatorInput;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EditingWindow
extends MultiPageEditorPart
implements IResourceChangeListener,
ISubscriber {
    private KenyaEditor kenyaEditor;
    private JavaEditor javaEditor;
    private Font font;
    private StyledText text;
    private KenyaHelperThread kht;
    private String subscriptionID;
    private GeneratedJava javaStorage;
    static /* synthetic */ Class class$0;

    public EditingWindow() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void createKenyaPage() {
        try {
            this.kenyaEditor = new KenyaEditor();
            int index = this.addPage((IEditorPart)this.kenyaEditor, this.getEditorInput());
            this.setPageText(index, this.kenyaEditor.getTitle());
            this.kenyaEditor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        EditingWindow.this.kht.getDocumentListener().documentChanged(null);
                    }
                }
            });
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createJavaPage() {
        try {
            this.javaEditor = new JavaEditor();
            this.javaStorage = new GeneratedJava(this.getFileName());
            GeneratedJavaInput jInput = new GeneratedJavaInput(this.javaStorage);
            MediationTerms terms = new MediationTerms((MediatorInput)this.kenyaEditor, (ICheckedCodeReceiver)this.kenyaEditor.getKenyaCodeManager(), (IJavaCodeReceiver)this.javaStorage);
            MediationSubscription sub = new MediationSubscription((ISubscriber)this, terms);
            this.subscriptionID = MediationService.getInstance().addSubscription((ISubscription)sub);
            int index = this.addPage((IEditorPart)this.javaEditor, (IEditorInput)jInput);
            this.setPageText(index, this.javaEditor.getTitle());
            this.javaEditor.setEnabled(false);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        this.createKenyaPage();
        this.createJavaPage();
        this.kht = new KenyaHelperThread("Kenya AutoBuild", this.subscriptionID);
        this.kht.schedule();
        this.kenyaEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).addDocumentListener(this.kht.getDocumentListener());
        MediationService.getInstance().provideASyncSubscriptionUpdate(this.subscriptionID);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.kht != null) {
            this.kht.stoppit();
        }
        MediationService.getInstance().cancelSubscription(this.subscriptionID);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.kenyaEditor.doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new AdaptedMultiPageEditorSite(this, editor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = EditingWindow.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)EditingWindow.this.kenyaEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(EditingWindow.this.kenyaEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    public void subscriptionUpdate(ISubscriptionData data) {
        if (this.javaStorage != null && this.javaStorage.hasChanged()) {
            UIUtils.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.javaEditor.doRevertToSaved();
                }
            });
        }
        if (data != null && Array.getLength(data.getContents()) > 0) {
            ICheckedCode cc = null;
            IJavaCode jc = null;
            if (!(data.getContents()[0] instanceof Exception)) {
                cc = (ICheckedCode)data.getContents()[0];
                jc = (IJavaCode)data.getContents()[1];
            }
            Collection ans = KenyaPlugin.getDefault().getPostBuildAnalyserFactories();
            Iterator iter = ans.iterator();
            while (iter.hasNext()) {
                IKenyaPostBuildAnalyserFactory element = (IKenyaPostBuildAnalyserFactory)iter.next();
                AbstractKenyaPostBuildAnalyser rec = element.createAnalyser(((IFileEditorInput)this.getEditorInput()).getFile());
                if (rec == null) continue;
                if (cc != null) {
                    rec.setCheckedCode(cc);
                }
                if (jc == null) continue;
                rec.setJavaCode(jc);
            }
        }
    }

    protected String getFileName() {
        return this.getEditorInput().getName().split("\\.")[0];
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.isAssignableFrom(clazz)) {
            return this.kenyaEditor;
        }
        Object o = this.kenyaEditor.getAdapter(adapter);
        return o == null ? super.getAdapter(adapter) : o;
    }
}

