/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.java.util;

import java.util.ArrayList;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;
import kenya.eclipse.multieditor.util.WhitespaceDetector;
import kenya.eclipse.multieditor.util.WordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JavaCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};

    public JavaCodeScanner(DefaultSyntaxColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.KEYWORD), null, 1));
        Token type = new Token((Object)new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.TYPE), null, 1));
        Token string = new Token((Object)new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

