/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.KenyaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class KenyaAnnotationHover
implements IAnnotationHover {
    protected static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    public static final KenyaAnnotationHoverType OVERVIEW_RULER_HOVER = new KenyaAnnotationHoverType();
    public static final KenyaAnnotationHoverType TEXT_RULER_HOVER = new KenyaAnnotationHoverType();
    public static final KenyaAnnotationHoverType VERTICAL_RULER_HOVER = new KenyaAnnotationHoverType();
    private IPreferenceStore fStore = KenyaPlugin.getDefault().getCombinedPreferenceStore();
    private KenyaAnnotationHoverType fType;

    public KenyaAnnotationHover(KenyaAnnotationHoverType type) {
        Assert.isTrue((OVERVIEW_RULER_HOVER.equals(type) || TEXT_RULER_HOVER.equals(type) || VERTICAL_RULER_HOVER.equals(type) ? 1 : 0) != 0);
        this.fType = type;
    }

    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int kenyaAnnotationLine = document.getLineOfOffset(position.getOffset());
                if (line == kenyaAnnotationLine) {
                    return 1;
                }
                if (kenyaAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getKenyaAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        ArrayList<Annotation> including = new ArrayList<Annotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            String key;
            AnnotationPreference preference;
            Position position;
            Annotation annotation = (Annotation)e.next();
            if (annotation.getText() == null || (position = model.getPosition(annotation)) == null || (preference = this.getAnnotationPreference(annotation)) == null || (!OVERVIEW_RULER_HOVER.equals(this.fType) ? (!TEXT_RULER_HOVER.equals(this.fType) ? VERTICAL_RULER_HOVER.equals(this.fType) && (key = preference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key) : ((key = preference.getTextPreferenceKey()) != null ? !this.fStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fStore.getBoolean(key))) : (key = preference.getOverviewRulerPreferenceKey()) == null || !this.fStore.getBoolean(key)) || this.isDuplicateKenyaAnnotation(messagesAtPosition, position, annotation.getText())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(annotation);
                    break;
                }
                case 2: {
                    including.add(annotation);
                }
            }
        }
        return this.select(exact, including);
    }

    private boolean isDuplicateKenyaAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List javaAnnotations = this.getKenyaAnnotationsForLine(sourceViewer, lineNumber);
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = (Annotation)javaAnnotations.get(0);
                if (!(annotation instanceof MarkerAnnotation)) {
                    return null;
                }
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                Iterator e = javaAnnotations.iterator();
                while (e.hasNext()) {
                    String message;
                    Annotation annotation = (Annotation)e.next();
                    if (!(annotation instanceof MarkerAnnotation) || (message = annotation.getText()) == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        return message;
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buf = new StringBuffer();
        buf.append("Multiple markers at this line:");
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            buf.append(String.valueOf(LINE_DELIM) + "\t- ");
            buf.append((String)e.next());
        }
        return buf.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    private static class KenyaAnnotationHoverType {
        KenyaAnnotationHoverType() {
        }
    }
}

