/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.NodeFinder;
import kenya.eclipse.ast.OccurrencesFinder;
import kenya.eclipse.buildext.AbstractKenyaPostBuildAnalyser;
import kenya.eclipse.buildext.util.MarkerPropertySetter;
import kenya.eclipse.multieditor.kenya.KenyaEditorMessages;
import kenya.eclipse.multieditor.kenya.KenyaSelectMarkerRulerAction2;
import kenya.eclipse.multieditor.kenya.KenyaSourceViewerConfiguration;
import kenya.eclipse.multieditor.kenya.ToggleCommentAction;
import kenya.eclipse.multieditor.kenya.correction.KenyaCorrectionAssistant;
import kenya.eclipse.multieditor.kenya.occurrences.ISelectionListenerWithAST;
import kenya.eclipse.multieditor.kenya.occurrences.MethodExitsFinder;
import kenya.eclipse.multieditor.kenya.occurrences.SelectionListenerWithASTManager;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.multieditor.text.CharacterPairMatcher;
import kenya.eclipse.ui.actions.AddBlockCommentAction;
import kenya.eclipse.ui.actions.CompositeActionGroup;
import kenya.eclipse.ui.actions.GenerateActionGroup;
import kenya.eclipse.ui.actions.IndentAction;
import kenya.eclipse.ui.actions.RefactorActionGroup;
import kenya.eclipse.ui.actions.RemoveBlockCommentAction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.subscription.MediatorInput;
import minijava.node.Node;
import minijava.node.PName;
import minijava.node.Start;
import minijava.node.TIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class KenyaEditor
extends AbstractDecoratedTextEditor
implements MediatorInput,
IGotoMarker {
    private Annotation[] fOccurrenceAnnotations = null;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    public static final int CORRECTIONASSIST_PROPOSALS = 50;
    protected CompositeActionGroup fActionGroups;
    private BracketInserter fBracketInserter = new BracketInserter();
    protected CharacterPairMatcher fBracketMatcher = new CharacterPairMatcher(BRACKETS);
    private CompositeActionGroup fContextMenuGroup;
    private GenerateActionGroup fGenerateActionGroup;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkMethodExitPoints;
    private ISelection fForcedMarkOccurrencesSelection;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ProjectionSupport fProjectionSupport;
    private KenyaCodeManager fCodeManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private Object getLockObject(IAnnotationModel annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals((Object)this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public KenyaEditor() {
        this.setRulerContextMenuId("#KenyaRulerContext");
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = KenyaEditorMessages.getResourceBundle();
        this.fActionGroups = new CompositeActionGroup();
        this.fContextMenuGroup = new CompositeActionGroup();
        Object action = new KenyaSelectMarkerRulerAction2(bundle, "KenyaEditor.RulerAnnotationSelection.", (ITextEditor)this);
        this.setAction("AnnotationAction", (IAction)action);
        action = new TextOperationAction(bundle, "CorrectionAssistProposal.", (ITextEditor)this, 50);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.correction.assist.proposals");
        this.setAction("CorrectionAssistProposal", (IAction)action);
        this.markAsStateDependentAction("CorrectionAssistProposal", true);
        action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(bundle, "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        action = new TextOperationAction(bundle, "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new ToggleCommentAction(bundle, "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        action = new TextOperationAction(bundle, "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        action = new AddBlockCommentAction(bundle, "AddBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.add.block.comment");
        this.setAction("AddBlockComment", (IAction)action);
        this.markAsStateDependentAction("AddBlockComment", true);
        this.markAsSelectionDependentAction("AddBlockComment", true);
        action = new RemoveBlockCommentAction(bundle, "RemoveBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.remove.block.comment");
        this.setAction("RemoveBlockComment", (IAction)action);
        this.markAsStateDependentAction("RemoveBlockComment", true);
        this.markAsSelectionDependentAction("RemoveBlockComment", true);
        action = new IndentAction(bundle, "Indent.", (ITextEditor)this, false);
        action.setActionDefinitionId("kenya.eclipse.multieditor.kenya.indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        action = new IndentAction(bundle, "Indent.", (ITextEditor)this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        if (this.getPreferenceStore().getBoolean("smart_tab")) {
            this.removeActionActivationCode("ShiftRight");
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
        this.fGenerateActionGroup = new GenerateActionGroup(this, "group.edit");
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit");
        this.fActionGroups.addGroup(rg);
        this.fActionGroups.addGroup(this.fGenerateActionGroup);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{this.fGenerateActionGroup, rg});
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        ruler.addDecorator(0, (IVerticalRulerColumn)column);
        ruler.addDecorator(1, this.createLineNumberRulerColumn());
        return ruler;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        viewer.doOperation(19);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean("closeBrackets");
        boolean closeStrings = preferenceStore.getBoolean("closeStrings");
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fMarkOccurrenceAnnotations) {
            this.installOccurrencesFinder();
        }
        this.getEditorSite().getShell().addShellListener((ShellListener)this.fActivationListener);
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        KenyaSourceViewer viewer = new KenyaSourceViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void dispose() {
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        if (this.fActivationListener != null) {
            Shell shell = this.getEditorSite().getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fActivationListener = null;
        }
        super.dispose();
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.appendToGroup("group.undo", (IContributionItem)new Separator("group.open"));
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mediator.ICheckedCode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == adapter) {
            return this.getKenyaCodeManager().getLastCheckedCode();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.Reader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2 == adapter) {
            return this.getReader();
        }
        return super.getAdapter(adapter);
    }

    protected StyledText getContents() {
        return this.getSourceViewer().getTextWidget();
    }

    public KenyaCodeManager getKenyaCodeManager() {
        if (this.fCodeManager == null) {
            this.fCodeManager = new KenyaCodeManager();
        }
        return this.fCodeManager;
    }

    public synchronized Reader getReader() {
        try {
            return new StringReader(this.getSourceViewer().getDocument().get());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTitle() {
        return "Kenya";
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block17: {
            block18: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                try {
                                    ISourceViewer sourceViewer = this.getSourceViewer();
                                    if (sourceViewer == null) {
                                        Object var5_3 = null;
                                        break block13;
                                    }
                                    String property = event.getProperty();
                                    if ("markOccurrences".equals(property)) {
                                        boolean markOccurrenceAnnotations;
                                        if (event.getNewValue() instanceof Boolean && (markOccurrenceAnnotations = ((Boolean)event.getNewValue()).booleanValue()) != this.fMarkOccurrenceAnnotations) {
                                            this.fMarkOccurrenceAnnotations = markOccurrenceAnnotations;
                                            if (!this.fMarkOccurrenceAnnotations) {
                                                this.uninstallOccurrencesFinder();
                                                break block14;
                                            } else {
                                                this.installOccurrencesFinder();
                                            }
                                        }
                                        break block14;
                                    }
                                    if ("markTypeOccurrences".equals(property)) {
                                        if (event.getNewValue() instanceof Boolean) {
                                            this.fMarkTypeOccurrences = (Boolean)event.getNewValue();
                                        }
                                        break block15;
                                    }
                                    if ("markMethodExitPoints".equals(property)) {
                                        if (event.getNewValue() instanceof Boolean) {
                                            this.fMarkMethodExitPoints = (Boolean)event.getNewValue();
                                        }
                                        break block16;
                                    }
                                    if (!"stickyOccurrences".equals(property)) break block17;
                                    if (event.getNewValue() instanceof Boolean) {
                                        this.fStickyOccurrenceAnnotations = (Boolean)event.getNewValue();
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    Object var5_8 = null;
                                    super.handlePreferenceStoreChanged(event);
                                    throw throwable;
                                }
                            }
                            super.handlePreferenceStoreChanged(event);
                            return;
                        }
                        Object var5_4 = null;
                        super.handlePreferenceStoreChanged(event);
                        return;
                    }
                    Object var5_5 = null;
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                Object var5_6 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var5_7 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var5_9 = null;
        super.handlePreferenceStoreChanged(event);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(new KenyaSourceViewerConfiguration());
        IPreferenceStore store = KenyaPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(store);
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkMethodExitPoints = store.getBoolean("markMethodExitPoints");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"kenya.eclipse.multieditor.kenyaEditorScope"});
    }

    protected void installOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, Start astRoot) {
                KenyaEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
        if (this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            SelectionListenerWithASTManager.getDefault().forceSelectionChange((ITextEditor)this, (ITextSelection)this.fForcedMarkOccurrencesSelection);
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected boolean isMarkingOccurrences() {
        return this.fMarkOccurrenceAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, Start astRoot) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (this.fCodeManager.recentCode != this.fCodeManager.recentValidCode) {
            this.removeOccurrenceAnnotations();
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        List matches = new ArrayList();
        if (matches.size() == 0) {
            Node node;
            MethodExitsFinder finder;
            String message;
            ISourceCodeLocation selectedLocation = LocationUtils.convert(selection.getOffset(), selection.getLength(), document);
            if ((this.fMarkMethodExitPoints || this.fMarkTypeOccurrences) && (message = (finder = new MethodExitsFinder()).initialise(node = NodeFinder.perform(astRoot, document, selectedLocation))) == null) {
                matches = finder.perform();
            }
            if (matches.size() == 0) {
                Node node2 = NodeFinder.perform(astRoot, document, selectedLocation);
                if (!(node2 instanceof TIdentifier) && !(node2 instanceof PName)) {
                    if (!this.fStickyOccurrenceAnnotations) {
                        this.removeOccurrenceAnnotations();
                    }
                    return;
                }
                OccurrencesFinder finder2 = new OccurrencesFinder();
                message = finder2.initialize(astRoot, this.fCodeManager.recentValidCode, document, selectedLocation);
                if (message == null) {
                    matches = finder2.perform();
                }
            } else if (!this.fMarkMethodExitPoints) {
                if (!this.fStickyOccurrenceAnnotations) {
                    this.removeOccurrenceAnnotations();
                }
                return;
            }
        }
        Position[] positions = new Position[matches.size()];
        int i = 0;
        Iterator each = matches.iterator();
        while (each.hasNext()) {
            Node currentNode = (Node)each.next();
            ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation(currentNode, document);
            positions[i++] = LocationUtils.convert(loc, document);
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, positions, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private final String CATEGORY = this.toString();
        private Stack fBracketLevelStack = new Stack();
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);

        BracketInserter() {
        }

        private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && document.getChar(end) == character;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
            try {
                int start = offset;
                IRegion startLine = document.getLineInformationOfOffset(start);
                int minStart = startLine.getOffset();
                while (start != minStart && Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheRight(IDocument document, int offset) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = KenyaEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(this, level, document){
                    final /* synthetic */ BracketInserter this$1;
                    private final /* synthetic */ BracketLevel val$level;
                    private final /* synthetic */ IDocument val$document;
                    {
                        this.this$1 = bracketInserter;
                        this.val$level = bracketLevel;
                        this.val$document = iDocument;
                    }

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((this.val$level.fFirstPosition.isDeleted || this.val$level.fFirstPosition.length == 0) && !this.val$level.fSecondPosition.isDeleted && this.val$level.fSecondPosition.offset == this.val$level.fFirstPosition.offset) {
                            try {
                                this.val$document.replace(this.val$level.fSecondPosition.offset, this.val$level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        if (BracketInserter.access$0(this.this$1).size() == 0) {
                            this.val$document.removePositionUpdater(BracketInserter.access$1(this.this$1));
                            try {
                                this.val$document.removePositionCategory(BracketInserter.access$2(this.this$1));
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                    }
                });
            }
        }

        public void resume(LinkedModeModel environment, int flags) {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || KenyaEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            ISourceViewer sourceViewer = KenyaEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case '(': {
                    if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                        return;
                    }
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    if (this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                case '\'': {
                    if (event.character == '\'') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                }
                case '\"': {
                    if (event.character == '\"') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                    try {
                        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__kenya_partitioning", (int)offset, (boolean)true);
                        if (!"__dftl_partition_content_type".equals(partition.getType())) {
                            return;
                        }
                        if (!KenyaEditor.this.validateEditorInputState()) {
                            return;
                        }
                        char character = event.character;
                        char closingCharacter = KenyaEditor.getPeerCharacter(character);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(character);
                        buffer.append(closingCharacter);
                        document.replace(offset, length, buffer.toString());
                        BracketLevel level = new BracketLevel();
                        this.fBracketLevelStack.push(level);
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                        LinkedModeModel model = new LinkedModeModel();
                        model.addLinkingListener((ILinkedModeListener)this);
                        model.addGroup(group);
                        model.forceInstall();
                        level.fOffset = offset;
                        level.fLength = 2;
                        if (this.fBracketLevelStack.size() == 1) {
                            document.addPositionCategory(this.CATEGORY);
                            document.addPositionUpdater(this.fUpdater);
                        }
                        level.fFirstPosition = new Position(offset, 1);
                        level.fSecondPosition = new Position(offset + 1, 1);
                        document.addPosition(this.CATEGORY, level.fFirstPosition);
                        document.addPosition(this.CATEGORY, level.fSecondPosition);
                        level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                        level.fUI.setSimpleMode(true);
                        level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, KenyaEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                        level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                        level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                        level.fUI.enter();
                        IRegion newSelection = level.fUI.getSelectedRegion();
                        sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                        event.doit = false;
                        break;
                    }
                    catch (BadLocationException e) {
                        KenyaPlugin.log(e);
                        break;
                    }
                    catch (BadPositionCategoryException e) {
                        KenyaPlugin.log(e);
                    }
                }
            }
        }

        static /* synthetic */ Stack access$0(BracketInserter bracketInserter) {
            return bracketInserter.fBracketLevelStack;
        }

        static /* synthetic */ IPositionUpdater access$1(BracketInserter bracketInserter) {
            return bracketInserter.fUpdater;
        }

        static /* synthetic */ String access$2(BracketInserter bracketInserter) {
            return bracketInserter.CATEGORY;
        }
    }

    private static class BracketLevel {
        Position fFirstPosition;
        int fLength;
        int fOffset;
        Position fSecondPosition;
        LinkedModeUI fUI;

        BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public String getCategory() {
            return this.fCategory;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fEscapeCharacter;
        final char fExitCharacter;
        final int fSize;
        final Stack fStack;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                BracketLevel level = (BracketLevel)this.fStack.peek();
                if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                    return null;
                }
                if (level.fSecondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = KenyaEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    public class KenyaCodeManager
    extends AbstractKenyaPostBuildAnalyser {
        private ICheckedCode recentCode;
        private ICheckedCode recentValidCode;
        static /* synthetic */ Class class$0;

        public synchronized ICheckedCode getLastCheckedCode() {
            return this.recentCode;
        }

        public synchronized ICheckedCode getLastValidCode() {
            return this.recentValidCode;
        }

        public void setCheckedCode(ICheckedCode code) {
            try {
                IFile resource;
                this.recentCode = code;
                if (!code.isErroredCode()) {
                    this.recentValidCode = code;
                }
                IEditorInput iEditorInput = KenyaEditor.this.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IFile)iEditorInput.getAdapter((Class)clazz)) == null) {
                    return;
                }
                resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                ArrayList allInfo = new ArrayList();
                allInfo.addAll(code.getInfos());
                if (code.isErroredCode()) {
                    allInfo.addAll(code.getErrors());
                }
                IWorkspaceRunnable r = new IWorkspaceRunnable(this, allInfo, resource){
                    final /* synthetic */ KenyaCodeManager this$1;
                    private final /* synthetic */ List val$allInfo;
                    private final /* synthetic */ IFile val$resource;
                    {
                        this.this$1 = kenyaCodeManager;
                        this.val$allInfo = list;
                        this.val$resource = iFile;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Iterator<E> it = this.val$allInfo.iterator();
                        while (it.hasNext()) {
                            ISourceCodeInformation info = (ISourceCodeInformation)it.next();
                            IDocument doc = KenyaCodeManager.access$2(this.this$1).getDocumentProvider().getDocument((Object)KenyaCodeManager.access$2(this.this$1).getEditorInput());
                            IMarker m = this.val$resource.createMarker("org.eclipse.core.resources.problemmarker");
                            MarkerPropertySetter.setProps(m, info);
                            ISourceCodeLocation loc = info.getLocation();
                            Position pos = LocationUtils.convert(loc, doc);
                            MarkerPropertySetter.setLocation(m, pos);
                        }
                    }
                };
                resource.getWorkspace().run(r, null, 1, null);
            }
            catch (CoreException coreException) {}
        }

        public void setJavaCode(IJavaCode code) {
        }

        static /* synthetic */ KenyaEditor access$2(KenyaCodeManager kenyaCodeManager) {
            return kenyaCodeManager.KenyaEditor.this;
        }
    }

    class KenyaSourceViewer
    extends ProjectionViewer {
        private KenyaCorrectionAssistant fCorrectionAssistant;
        private boolean fIgnoreTextConverters = false;
        private List fTextConverters;

        public KenyaSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
            super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public boolean canDoOperation(int operation) {
            if (operation == 50) {
                return this.isEditable();
            }
            return super.canDoOperation(operation);
        }

        public void configure(SourceViewerConfiguration configuration) {
            super.configure(configuration);
            this.fCorrectionAssistant = new KenyaCorrectionAssistant((ITextEditor)KenyaEditor.this);
            this.fCorrectionAssistant.install((ITextViewer)this);
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    KenyaEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 50: {
                    String msg = this.fCorrectionAssistant.showPossibleCompletions();
                    KenyaEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
            }
            super.doOperation(operation);
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }

        public void unconfigure() {
            if (this.fCorrectionAssistant != null) {
                this.fCorrectionAssistant.uninstall();
                this.fCorrectionAssistant = null;
            }
            super.unconfigure();
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = KenyaEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private boolean fCanceled = false;
        private IDocument fDocument;
        private Position[] fPositions;
        private ISelectionValidator fPostSelectionValidator;
        private IProgressMonitor fProgressMonitor;
        private ISelection fSelection;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super(KenyaEditorMessages.getString("KenyaEditor.markOccurrences.job.name"));
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (KenyaEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)KenyaEditor.this.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && KenyaEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = KenyaEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = KenyaEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)KenyaEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block16: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block16;
                    }
                    annotationMap.put(new Annotation("kenya.eclipse.ui.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object object = KenyaEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(KenyaEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    KenyaEditor.this.removeOccurrenceAnnotations();
                    Iterator iter = annotationMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry mapEntry = iter.next();
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                KenyaEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (KenyaEditor.this.fOccurrencesFinderJob != null) {
                KenyaEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }

        public void install() {
            ISourceViewer sourceViewer = KenyaEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = KenyaEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = KenyaEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)KenyaEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }
    }

    private class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            if (KenyaEditor.this.fMarkOccurrenceAnnotations && KenyaEditor.this.isActivePart()) {
                KenyaEditor.this.fForcedMarkOccurrencesSelection = KenyaEditor.this.getSelectionProvider().getSelection();
                SelectionListenerWithASTManager.getDefault().forceSelectionChange((ITextEditor)KenyaEditor.this, (ITextSelection)KenyaEditor.this.fForcedMarkOccurrencesSelection);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            KenyaEditor.this.removeOccurrenceAnnotations();
        }
    }
}

