/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import java.util.Iterator;
import java.util.ResourceBundle;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.style.KenyaStyleManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class KenyaSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private AnnotationPreferenceLookup fAnnotationPreferenceLookup;
    private IPreferenceStore fStore;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;
    static /* synthetic */ Class class$0;

    public KenyaSelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fBundle = bundle;
        this.fTextEditor = editor;
        this.fAnnotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
        this.fStore = KenyaPlugin.getDefault().getCombinedPreferenceStore();
    }

    public void run() {
        if (this.fHasCorrection) {
            ITextOperationTarget operation;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((operation = (ITextOperationTarget)this.fTextEditor.getAdapter((Class)clazz)) != null && operation.canDoOperation(50)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(50);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.findJavaAnnotation();
        this.setEnabled(true);
        if (this.fHasCorrection) {
            this.initialize(this.fBundle, "KenyaSelectAnnotationRulerAction.QuickFix.");
            return;
        }
        this.initialize(this.fBundle, "KenyaSelectAnnotationRulerAction.GotoAnnotation.");
        super.update();
    }

    private void findJavaAnnotation() {
        this.fPosition = null;
        this.fHasCorrection = false;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            String key;
            boolean isReadOnly;
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted()) continue;
            int annotationLayer = annotationAccess.getLayer(annotation);
            if (annotationAccess != null && annotationLayer < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (!isReadOnly && KenyaStyleManager.hasCorrections(annotation)) {
                this.fPosition = position;
                this.fHasCorrection = true;
                layer = annotationLayer;
                continue;
            }
            AnnotationPreference preference = this.fAnnotationPreferenceLookup.getAnnotationPreference(annotation);
            if (preference == null || (key = preference.getVerticalRulerPreferenceKey()) == null || !this.fStore.getBoolean(key)) continue;
            this.fPosition = position;
            this.fHasCorrection = false;
            layer = annotationLayer;
        }
    }
}

