/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import java.util.ResourceBundle;
import kenya.eclipse.style.KenyaStyleManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SelectAnnotationRulerAction;

public class KenyaSelectMarkerRulerAction2
extends SelectAnnotationRulerAction {
    public static final String NO_BREAKPOINT_ANNOTATION = "org.eclipse.jdt.internal.ui.NoBreakpointAnnotation";
    static /* synthetic */ Class class$0;

    public KenyaSelectMarkerRulerAction2(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void annotationDefaultSelected(VerticalRulerEvent event) {
        Position position;
        Annotation annotation = event.getSelectedAnnotation();
        IAnnotationModel model = this.getAnnotationModel();
        if (this.isBreakpoint(annotation)) {
            this.triggerAction("RulerDoubleClick");
        }
        if ((position = model.getPosition(annotation)) == null) {
            return;
        }
        if (this.isQuickFixTarget(annotation)) {
            ITextOperationTarget operation;
            ITextEditor iTextEditor = this.getTextEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((operation = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz)) != null && operation.canDoOperation(50)) {
                this.getTextEditor().selectAndReveal(position.getOffset(), position.getLength());
                operation.doOperation(50);
                return;
            }
        }
        super.annotationDefaultSelected(event);
    }

    private boolean isBreakpoint(Annotation annotation) {
        return annotation.getType().equals("org.eclipse.debug.core.breakpoint") || annotation.getType().equals(NO_BREAKPOINT_ANNOTATION);
    }

    private boolean isQuickFixTarget(Annotation a) {
        if (a instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)a;
            return KenyaStyleManager.getResolutionManager().hasResolutions(ma.getMarker());
        }
        return false;
    }

    private void triggerAction(String actionID) {
        IAction action = this.getTextEditor().getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action instanceof ISelectionListener) {
                ((ISelectionListener)action).selectionChanged(null, null);
            }
            if (action.isEnabled()) {
                action.run();
            }
        }
    }
}

