/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.KenyaAnnotationHover;
import kenya.eclipse.multieditor.kenya.completion.KenyaCompletionProcessor;
import kenya.eclipse.multieditor.kenya.util.KenyaAutoIndentStrategy;
import kenya.eclipse.multieditor.kenya.util.KenyaDoubleClickSelector;
import kenya.eclipse.multieditor.text.JavaFormattingStrategy;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class KenyaSourceViewerConfiguration
extends SourceViewerConfiguration {
    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new KenyaAnnotationHover(KenyaAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new KenyaAnnotationHover(KenyaAnnotationHover.OVERVIEW_RULER_HOVER);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return KenyaConstants.EDITOR_TAB_WIDTH;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getAutoEditStrategy(sourceViewer, contentType)};
    }

    protected IAutoEditStrategy getAutoEditStrategy(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? new KenyaAutoIndentStrategy() : new DefaultIndentLineAutoEditStrategy();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__kenya_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_multiline_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)new KenyaCompletionProcessor(), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(300);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(KenyaPlugin.getDefault().getKenyaColourManager().getColor(new RGB(255, 255, 255)));
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
        return null;
    }

    public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? "//" : null;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.equals("__dftl_partition_content_type")) {
            return new String[]{this.getDefaultPrefix(sourceViewer, contentType)};
        }
        return super.getDefaultPrefixes(sourceViewer, contentType);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new KenyaDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        DefaultSyntaxColorProvider provider = KenyaPlugin.getDefault().getSyntaxColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)KenyaPlugin.getDefault().getKenyaCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.MULTI_LINE_COMMENT))));
        reconciler.setDamager((IPresentationDamager)dr, "__java_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_multiline_comment");
        return reconciler;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

