/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.KenyaEditor;
import kenya.eclipse.multieditor.kenya.KenyaEditorMessages;
import kenya.eclipse.ui.KenyaImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleMarkOccurrencesAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleMarkOccurrencesAction() {
        super(KenyaEditorMessages.getResourceBundle(), "ToggleMarkOccurrencesAction.", null, 2);
        KenyaImages.setToolImageDescriptors((IAction)this, "mark_occurrences.gif");
        this.setToolTipText(KenyaEditorMessages.getString("ToggleMarkOccurrencesAction.tooltip"));
        this.update();
    }

    public void run() {
        this.fStore.setValue("markOccurrences", this.isChecked());
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = false;
        if (editor instanceof KenyaEditor) {
            checked = ((KenyaEditor)editor).isMarkingOccurrences();
        }
        this.setChecked(checked);
        this.setEnabled(editor != null);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = KenyaPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("markOccurrences") && event.getNewValue() instanceof Boolean) {
            this.setChecked((Boolean)event.getNewValue());
        }
    }
}

