/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.completion;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kenya.builtIns.BuiltInMethodsLoader;
import kenya.builtIns.IBuiltInMethod;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeFinder;
import kenya.eclipse.ast.NodeFinder2;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.Resolver;
import kenya.eclipse.ast.SimpleASTProvider;
import kenya.eclipse.ast.bindings.ClassBinding;
import kenya.eclipse.ast.bindings.EnumBinding;
import kenya.eclipse.ast.bindings.VariableBinding;
import kenya.eclipse.multieditor.kenya.KenyaEditor;
import kenya.eclipse.multieditor.kenya.completion.JavaParameterListValidator;
import kenya.eclipse.multieditor.kenya.completion.TypeIdentifierPair;
import kenya.eclipse.multieditor.kenya.completion.VariableDeclarationFinder;
import kenya.eclipse.multieditor.kenya.util.GroupedArrayList;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.ui.KenyaImages;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.types.KType;
import mediator.ICheckedCode;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassInnerDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AReferenceTypeType;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Node;
import minijava.node.Start;
import minijava.node.TIdentifier;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class KenyaCompletionProcessor
implements IContentAssistProcessor {
    private static final String FIELDS = "_fields";
    private static final String FUNCTIONS = "_functions";
    private static final String BUILTINS = "_built_ins";
    private static final String ID = "\\w+";
    private static final String METH = "((\\w+)\\s*\\()";
    private static final String QUAL = "(\\s*\\.\\s*\\w+(\\[.*\\])*)";
    private static final String VAR_ACCESS = "(((\\w+)\\s*\\()*(\\w+(\\[.*\\])*(\\s*\\.\\s*\\w+(\\[.*\\])*)*))";
    private static final Pattern fieldAccess = Pattern.compile("(((\\w+)\\s*\\()*(\\w+(\\[.*\\])*(\\s*\\.\\s*\\w+(\\[.*\\])*)*))!?\\s*\\.\\s*(\\w+(\\[.*\\])*)?");
    private static final Pattern methCall = Pattern.compile("\\s*((\\w+)\\s*\\()\\s*");
    private static final Pattern nothing = Pattern.compile("\\s*(.*\\s+)?(\\w+([\\s!]*\\()?)?[\\s!]*");
    private static final String objecttype = "\\@#\\d+";
    protected IContextInformationValidator fValidator;
    static /* synthetic */ Class class$0;

    protected String shortenToLast(String text, boolean lastMethCall) {
        int exclam;
        int brace;
        int eq;
        int semi = text.lastIndexOf(59) + 1;
        if (semi > 0) {
            text = text.substring(semi);
        }
        if ((eq = text.lastIndexOf(61) + 1) > 0) {
            text = text.substring(eq);
        }
        if ((brace = text.lastIndexOf(40)) > 0 && lastMethCall) {
            brace = text.substring(0, brace).lastIndexOf(40);
        }
        if (brace >= 0) {
            text = text.substring(brace + 1);
        }
        if ((exclam = text.lastIndexOf(33) + 1) > 0) {
            text = text.substring(exclam);
        }
        return text;
    }

    protected KenyaEditor getKenyaEditor(ITextViewer viewer) {
        KenyaEditor editor;
        IEditorPart iEditorPart = KenyaPlugin.getActivePage().getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kenya.eclipse.multieditor.kenya.KenyaEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((editor = (KenyaEditor)((Object)iEditorPart.getAdapter((Class)clazz))) == null || editor.getViewer() != viewer) {
            return null;
        }
        return editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        GroupedArrayList list = new GroupedArrayList(3);
        list.addGroup(FIELDS);
        list.addGroup(FUNCTIONS);
        list.addGroup(BUILTINS);
        KenyaEditor editor = this.getKenyaEditor(viewer);
        if (editor == null) {
            return new ICompletionProposal[0];
        }
        ICheckedCode code = editor.getKenyaCodeManager().getLastValidCode();
        if (code == null) {
            code = editor.getKenyaCodeManager().getLastCheckedCode();
        }
        try {
            Matcher m;
            IDocument doc = viewer.getDocument();
            IRegion lineinfo = doc.getLineInformationOfOffset(documentOffset);
            int start = lineinfo.getOffset();
            String text = doc.get(start, documentOffset - start);
            String ntext = this.shortenToLast(text, false);
            Start ast = SimpleASTProvider.getAST(editor.getReader());
            if (ast == null) {
                ast = SimpleASTProvider.getAST(code);
            }
            if ((m = fieldAccess.matcher(text)).find(0) && m.end() == text.length()) {
                String last = m.group(4);
                int lastindex = start + m.start(4);
                int lastdot = last.lastIndexOf(46) + 1;
                if (lastdot > 0) {
                    last = last.substring(lastdot);
                }
                String match = m.start(9) > 0 ? m.group(9) : "";
                String lastNoAccess = last.indexOf(91) > 0 ? last.substring(0, last.indexOf(91)) : last;
                Position pos = new Position(lastindex, lastNoAccess.length());
                Node n = NodeFinder.perform(ast, doc, pos);
                if (!(n instanceof TIdentifier)) {
                    IFunction f;
                    if (n == null && (f = Resolver.getContainingMethod(LocationUtils.convert(pos, doc), code)) != null) {
                        n = f.getDeclarationNode();
                    }
                    if (n != null) {
                        n = NodeFinder2.perform(n, lastNoAccess);
                    }
                }
                if (n instanceof TIdentifier) {
                    ArrayList l = new ArrayList();
                    this.computeFieldAccessProposals((TIdentifier)n, code, l, documentOffset, match, !lastNoAccess.equals(last));
                    ICompletionProposal[] pps = l.toArray(new ICompletionProposal[l.size()]);
                    return this.sort(pps);
                }
            }
            if ((m = nothing.matcher(ntext)).find()) {
                int s = m.start(2);
                String match = s >= 0 ? m.group(2) : "";
                ArrayList l = new ArrayList();
                ISourceCodeLocation loc = LocationUtils.convert(documentOffset, 0, doc);
                IFunction fun = Resolver.getContainingMethod(loc, code);
                if (fun == null) {
                    throw new BadLocationException();
                }
                this.computeVariableProposals(code, loc, l, documentOffset, this.shortenToLast(match, false));
                Object[] vars = this.sort(l.toArray(new ICompletionProposal[l.size()]));
                list.addAllToGroup(FIELDS, vars);
                l.clear();
                this.computeFunctionCallProposals(code, l, documentOffset, match);
                Object[] funs = this.sort(l.toArray(new ICompletionProposal[l.size()]));
                list.addAllToGroup(FUNCTIONS, funs);
                l.clear();
                this.computeBuiltinMethodCallProposals(l, documentOffset, match);
                Object[] bims = this.sort(l.toArray(new ICompletionProposal[l.size()]));
                list.addAllToGroup(BUILTINS, bims);
            }
            return (ICompletionProposal[])list.toArray(new ICompletionProposal[list.size()]);
        }
        catch (BadLocationException badLocationException) {
            return new ICompletionProposal[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void computeFieldAccessProposals(TIdentifier tid, ICheckedCode code, List list, int offset, String matchPrefix, boolean isArrayAccess) {
        IBinding b = Resolver.resolve(tid, code);
        if (b != null) {
            AClassTypeReferenceType type;
            TIdentifier classname;
            IBinding bb;
            if (b instanceof VariableBinding && ((VariableBinding)b).isArray() && !isArrayAccess) {
                String name = "length";
                String insert = name.substring(matchPrefix.length());
                Object[] format = new String[]{name, "int"};
                String display = MessageFormat.format("{0}  {1}", format);
                CompletionProposal comp = new CompletionProposal(insert, offset, 0, insert.length(), KenyaImages.getImage("kenya.eclipse.field_public_obj.gif"), display, null, "");
                list.add(comp);
                return;
            }
            if (b.getType() != null && b.getType() instanceof AReferenceTypeType && (bb = Resolver.resolve(classname = (type = (AClassTypeReferenceType)((AReferenceTypeType)b.getType()).getReferenceType()).getIdentifier(), code)) != null) {
                void var12_17;
                void var11_15;
                LinkedList ll;
                String id;
                if (bb instanceof ClassBinding) {
                    AClassDecDeclaration n = (AClassDecDeclaration)bb.getDeclaringNode();
                    id = NodeToString.toString((Node)n.getIdentifier());
                    ll = n.getClassInnerDeclaration();
                } else if (bb instanceof EnumBinding) {
                    AEnumDecDeclaration n = (AEnumDecDeclaration)bb.getDeclaringNode();
                    id = NodeToString.toString((Node)n.getIdentifier());
                    AEnumList el = (AEnumList)n.getEnumList();
                    ll = el.getCommaEnumList();
                } else {
                    return;
                }
                this.computeClassInnerCompletions((String)var11_15, var12_17.iterator(), list, offset, matchPrefix);
            }
        }
    }

    protected void computeVariableProposals(ICheckedCode code, ISourceCodeLocation loc, List list, int offset, String matchPrefix) {
        IFunction fun = Resolver.getContainingMethod(loc, code);
        if (fun == null) {
            return;
        }
        VariableDeclarationFinder finder = new VariableDeclarationFinder(fun, loc);
        List l = finder.perform();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            TypeIdentifierPair pair = (TypeIdentifierPair)it.next();
            String insert = pair.getIdString();
            ISourceCodeLocation location = NodeTools.getLocation((Node)pair.getId());
            if (!insert.startsWith(matchPrefix) || !LocationUtils.occursBefore(location, loc)) continue;
            String display = String.valueOf(insert) + "  " + pair.getTypeString();
            IContextInformation info = null;
            insert = insert.substring(matchPrefix.length());
            Image image = KenyaImages.getImage(pair.isLocal() ? "kenya.eclipse.localvariable_obj.gif" : "kenya.eclipse.field_public_obj.gif");
            list.add(new CompletionProposal(insert, offset, 0, insert.length(), image, display, info, ""));
        }
    }

    protected void computeFunctionCallProposals(ICheckedCode code, List list, int offset, String matchPrefix) {
        IFunction[] funs = code.getFunctions();
        int i = 0;
        while (i < funs.length) {
            IFunction f = funs[i];
            String insert = String.valueOf(f.getName()) + "()";
            if (insert.startsWith(matchPrefix)) {
                String display = NodeToString.toString((Node)f.getDeclarationNode());
                String block = NodeToString.toString((Node)f.getDeclarationNode().getBlock());
                int firstspace = display.indexOf(32);
                int decl = display.indexOf(block);
                display = display.substring(firstspace + 1, decl - 1);
                display = String.valueOf(display) + "  " + f.getReturnType().getName();
                StringBuffer params = new StringBuffer();
                int j = 0;
                while (j < f.getArguments().length) {
                    IVariable var = f.getArguments()[j];
                    params.append(var.getType().getName()).append(' ').append(var.getName()).append(", ");
                    ++j;
                }
                params.setLength(Math.max(0, params.length() - 2));
                ContextInformation info = params.length() > 0 ? new ContextInformation(insert, params.toString()) : null;
                insert = insert.substring(matchPrefix.length());
                int cursorPos = insert.length() - (f.getArguments().length > 0 ? 1 : 0);
                list.add(new CompletionProposal(insert, offset, 0, cursorPos, KenyaImages.getImage("kenya.eclipse.methpub_obj.gif"), display, (IContextInformation)info, MessageFormat.format("Method call: {0}", funs[i])));
            }
            ++i;
        }
    }

    protected void computeBuiltinMethodCallProposals(List list, int offset, String matchPrefix) {
        boolean noBrackets = false;
        int bracket = matchPrefix.indexOf(40);
        if (bracket > 0) {
            noBrackets = true;
            matchPrefix = matchPrefix.substring(0, bracket);
        }
        Set builtIns = BuiltInMethodsLoader.getBuiltInMethods();
        Iterator it = builtIns.iterator();
        while (it.hasNext()) {
            IBuiltInMethod bim = (IBuiltInMethod)it.next();
            String name = bim.getName();
            if (!name.startsWith(matchPrefix)) continue;
            String params = this.ktypeParametersToString(bim.getMethodParameters());
            if (params.indexOf(35) > 0 || name.indexOf(35) > 0) {
                params = params.replaceAll(objecttype, "Anything");
            }
            String insert = name;
            if (!noBrackets) {
                insert = String.valueOf(insert) + "()";
            }
            ContextInformation info = params.length() > 0 ? new ContextInformation(insert, params.toString()) : null;
            insert = insert.substring(matchPrefix.length());
            int cursorPos = Math.max(0, insert.length() - (bim.getMethodParameters().size() > 0 ? 1 : 0));
            String display = String.valueOf(name) + '(' + params + ')' + "  " + bim.getReturnType().getName();
            list.add(new CompletionProposal(insert, offset, 0, cursorPos, KenyaImages.getImage("kenya.eclipse.methpub_obj.gif"), display, (IContextInformation)info, MessageFormat.format("Method call: {0}", name)));
        }
    }

    protected void computeClassInnerCompletions(String containingType, Iterator it, List list, int offset, String matchPrefix) {
        while (it.hasNext()) {
            AVarDecInnerDeclaration v;
            AClassInnerDeclaration inner = (AClassInnerDeclaration)it.next();
            String name = null;
            String type = null;
            if (inner.getInnerDeclaration() instanceof AVarDecInnerDeclaration) {
                v = (AVarDecInnerDeclaration)inner.getInnerDeclaration();
                name = NodeToString.toString((Node)v.getIdentifier());
                type = NodeToString.toString((Node)v.getType());
            } else if (inner.getInnerDeclaration() instanceof AArrayDecInnerDeclaration) {
                v = (AArrayDecInnerDeclaration)inner.getInnerDeclaration();
                name = NodeToString.toString((Node)v.getIdentifier());
                type = NodeToString.toString((Node)v.getType());
            }
            if (name == null || !name.startsWith(matchPrefix)) continue;
            IContextInformation information = null;
            String insert = name.substring(matchPrefix.length());
            Object[] format = new String[]{name, type, containingType};
            String display = MessageFormat.format("{0}  {1} - {2}", format);
            CompletionProposal comp = new CompletionProposal(insert, offset, 0, insert.length(), KenyaImages.getImage("kenya.eclipse.field_public_obj.gif"), display, information, "");
            list.add(comp);
        }
    }

    protected String ktypeParametersToString(List list) {
        StringBuffer buf = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            KType t = (KType)it.next();
            buf.append(t.getName());
            buf.append(' ');
            buf.append('x');
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected ICompletionProposal[] sort(ICompletionProposal[] cps) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ICompletionProposal && o2 instanceof ICompletionProposal) {
                    return this.compare((ICompletionProposal)o1, (ICompletionProposal)o2);
                }
                return 0;
            }

            public int compare(ICompletionProposal a, ICompletionProposal b) {
                return a.getDisplayString().compareTo(b.getDisplayString());
            }
        };
        Arrays.sort(cps, c);
        return cps;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ArrayList<ContextInformation> list = new ArrayList<ContextInformation>();
        KenyaEditor editor = this.getKenyaEditor(viewer);
        if (editor == null) {
            return new IContextInformation[0];
        }
        ICheckedCode code = editor.getKenyaCodeManager().getLastValidCode();
        try {
            IDocument doc = viewer.getDocument();
            IRegion lineinfo = doc.getLineInformationOfOffset(documentOffset);
            int start = lineinfo.getOffset();
            String text = doc.get(start, documentOffset - start);
            text = this.shortenToLast(text, true);
            Matcher m = methCall.matcher(text);
            if (m.find() && m.start() == 0) {
                String meth = m.group(2);
                IFunction[] funs = code.getFunctions();
                int i = 0;
                while (i < funs.length) {
                    IFunction f = funs[i];
                    String insert = f.getName();
                    if (insert.equals(meth)) {
                        ContextInformation info;
                        StringBuffer params = new StringBuffer();
                        int j = 0;
                        while (j < f.getArguments().length) {
                            IVariable var = f.getArguments()[j];
                            params.append(var.getType().getName()).append(' ').append(var.getName()).append(", ");
                            ++j;
                        }
                        params.setLength(Math.max(0, params.length() - 2));
                        insert = String.valueOf(insert) + "(" + params.toString() + ")";
                        ContextInformation contextInformation = info = params.length() > 0 ? new ContextInformation(insert, params.toString()) : null;
                        if (info != null) {
                            list.add(info);
                        }
                    }
                    ++i;
                }
                if (list.size() == 0) {
                    Set builtIns = BuiltInMethodsLoader.getBuiltInMethods();
                    Iterator it = builtIns.iterator();
                    while (it.hasNext()) {
                        ContextInformation info;
                        IBuiltInMethod bim = (IBuiltInMethod)it.next();
                        String name = bim.getName();
                        if (!name.startsWith(meth)) continue;
                        String params = this.ktypeParametersToString(bim.getMethodParameters());
                        if (params.indexOf(35) > 0 || name.indexOf(35) > 0) {
                            params = params.replaceAll(objecttype, "Anything");
                        }
                        String insert = String.valueOf(name) + "(" + params.toString() + ")";
                        ContextInformation contextInformation = info = params.length() > 0 ? new ContextInformation(insert, params.toString()) : null;
                        if (info == null) continue;
                        list.add(info);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return list.toArray(new IContextInformation[list.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '('};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }
}

