/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.correction;

import java.util.Iterator;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.correction.KenyaCorrectionProcessor;
import kenya.eclipse.multieditor.util.KenyaColourManager;
import kenya.eclipse.ui.htmlutil.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class KenyaCorrectionAssistant
extends ContentAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;

    public KenyaCorrectionAssistant(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        KenyaCorrectionProcessor processor = new KenyaCorrectionProcessor(this);
        this.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        this.enableAutoActivation(false);
        this.enableAutoInsert(false);
        this.setContextInformationPopupOrientation(20);
        this.setInformationControlCreator(this.getInformationControlCreator());
        KenyaColourManager manager = KenyaPlugin.getDefault().getKenyaColourManager();
        IPreferenceStore store = KenyaPlugin.getDefault().getPreferenceStore();
        Color c = KenyaCorrectionAssistant.getColor(store, "content_assist_proposals_foreground", manager);
        this.setProposalSelectorForeground(c);
        c = KenyaCorrectionAssistant.getColor(store, "content_assist_proposals_background", manager);
        this.setProposalSelectorBackground(c);
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore store, String key, KenyaColourManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fViewer = textViewer;
    }

    public void uninstall() {
        super.uninstall();
    }

    public String showPossibleCompletions() {
        int invocationOffset;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleCompletions();
        }
        Point selectedRange = this.fViewer.getSelectedRange();
        this.fPosition = null;
        if (selectedRange.y == 0 && (invocationOffset = this.computeOffsetWithCorrection(selectedRange.x)) != -1) {
            this.storePosition();
            this.fViewer.setSelectedRange(invocationOffset, 0);
            this.fViewer.revealRange(invocationOffset, 0);
        }
        return super.showPossibleCompletions();
    }

    private int computeOffsetWithCorrection(int initalOffset) {
        IRegion lineInfo = null;
        try {
            lineInfo = this.fViewer.getDocument().getLineInformationOfOffset(initalOffset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int startOffset = lineInfo.getOffset();
        int endOffset = startOffset + lineInfo.getLength();
        int result = this.computeOffsetWithCorrection(startOffset, endOffset, initalOffset);
        if (result > 0 && result != initalOffset) {
            return result;
        }
        return -1;
    }

    private int computeOffsetWithCorrection(int startOffset, int endOffset, int initialOffset) {
        IEditorInput input = this.fEditor.getEditorInput();
        IDocumentProvider docProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IAnnotationModel model = docProvider.getAnnotationModel((Object)input);
        int invocationOffset = -1;
        int offsetOfFirstProblem = Integer.MAX_VALUE;
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annot = (Annotation)iter.next();
            if (!KenyaCorrectionProcessor.isQuickFixableType(annot) || !this.isIncluded(pos = model.getPosition(annot), startOffset, endOffset) || !KenyaCorrectionProcessor.hasCorrections(annot)) continue;
            offsetOfFirstProblem = Math.min(offsetOfFirstProblem, pos.getOffset());
            if (initialOffset != (invocationOffset = this.computeBestOffset(invocationOffset, pos, initialOffset))) continue;
            return initialOffset;
        }
        if (initialOffset < offsetOfFirstProblem && offsetOfFirstProblem != Integer.MAX_VALUE) {
            return offsetOfFirstProblem;
        }
        return invocationOffset;
    }

    private boolean isIncluded(Position pos, int lineStart, int lineEnd) {
        return pos != null && pos.getOffset() >= lineStart && pos.getOffset() + pos.getLength() <= lineEnd;
    }

    private int computeBestOffset(int invocationOffset, Position pos, int initalOffset) {
        int newOffset = pos.offset;
        if (newOffset <= initalOffset && initalOffset <= newOffset + pos.length) {
            return initalOffset;
        }
        if (invocationOffset < 0) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset >= initalOffset) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset < initalOffset) {
            return Math.max(invocationOffset, newOffset);
        }
        if (invocationOffset <= initalOffset) {
            return invocationOffset;
        }
        return Math.max(invocationOffset, newOffset);
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition() {
        int initalOffset = this.fViewer.getSelectedRange().x;
        int length = this.fViewer.getSelectedRange().y;
        this.fPosition = new Position(initalOffset, length);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }
}

