/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kenya.eclipse.multieditor.kenya.correction.EmptyProposal;
import kenya.eclipse.multieditor.kenya.correction.KenyaCorrectionAssistant;
import kenya.eclipse.multieditor.kenya.correction.MarkerResolutionProposal;
import kenya.eclipse.style.KenyaStyleManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class KenyaCorrectionProcessor
implements IContentAssistProcessor {
    private KenyaCorrectionAssistant fAssistant;

    public KenyaCorrectionProcessor(KenyaCorrectionAssistant assistant) {
        this.fAssistant = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IEditorPart part = this.fAssistant.getEditor();
        IEditorInput input = part.getEditorInput();
        IDocumentProvider docProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IAnnotationModel model = docProvider.getAnnotationModel((Object)input);
        ArrayList<EmptyProposal> proposals = new ArrayList<EmptyProposal>();
        if (model != null) {
            this.processAnnotations(offset, model, proposals);
        }
        if (proposals.isEmpty()) {
            proposals.add(new EmptyProposal("No Corrections available"));
        }
        ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
        return res;
    }

    private void processAnnotations(int offset, IAnnotationModel model, ArrayList proposals) {
        ArrayList problems = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!KenyaCorrectionProcessor.isQuickFixableType(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            this.processAnnotation(annotation, pos, problems, proposals);
        }
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void processAnnotation(Annotation curr, Position pos, List problems, List proposals) {
        if (curr instanceof SimpleMarkerAnnotation) {
            IMarker marker = ((SimpleMarkerAnnotation)curr).getMarker();
            IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
            if (res.length > 0) {
                int i = 0;
                while (i < res.length) {
                    proposals.add(new MarkerResolutionProposal(res[i], marker));
                    ++i;
                }
            }
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public static boolean isQuickFixableType(Annotation annot) {
        return annot instanceof SimpleMarkerAnnotation && !annot.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annot) {
        return KenyaStyleManager.hasCorrections(annot);
    }
}

