/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.multieditor.kenya.refactoring.SortedOperationList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;

public class DocumentModificationOperation {
    protected SortedOperationList fOperations = new SortedOperationList();
    protected Map fRequiredInput;
    protected Map fRequiredValidation;

    public DocumentModificationOperation(Map inputsRequired, Map validationRequired) {
        this.setRequiredInput(inputsRequired);
        this.setRequiredValidation(validationRequired);
    }

    public DocumentModificationOperation() {
        this(null, null);
    }

    public void setRequiredInput(Map inputsRequired) {
        this.fRequiredInput = inputsRequired != null ? inputsRequired : new HashMap(0);
    }

    public void setRequiredValidation(Map validationRequired) {
        this.fRequiredValidation = validationRequired != null ? validationRequired : new HashMap(0);
    }

    public void addOperation(DocumentTextOperation op) {
        this.fOperations.add(op);
    }

    public void run(IDocument doc) {
        HashMap replacements = new HashMap(this.fRequiredInput.size());
        Iterator it = this.fRequiredInput.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IInputValidator validator = (IInputValidator)this.fRequiredValidation.get(entry.getValue());
            InputDialog d = new InputDialog(KenyaPlugin.getActiveWorkbenchShell(), "Input required..", entry.getKey().toString(), "", validator);
            d.setBlockOnOpen(true);
            d.create();
            int choice = d.open();
            if (choice != 0) {
                MessageDialog.openInformation((Shell)KenyaPlugin.getActiveWorkbenchShell(), (String)"Cancelled", (String)"You have chosen to cancel the process,\nno changes will be performed");
                return;
            }
            String newId = d.getValue();
            replacements.put(entry.getValue(), newId);
        }
        DocumentTextOperation[] ops = this.fOperations.toArray();
        int i = ops.length - 1;
        while (i >= 0) {
            DocumentTextOperation op = ops[i];
            try {
                op.perform(doc, replacements);
            }
            catch (BadLocationException badLocationException) {}
            --i;
        }
    }
}

