/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.refactoring;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentTextOperation {
    protected static final String EMPTY = "";
    protected String fReplaceWith;
    protected int fOffset;
    protected int fLength;

    protected DocumentTextOperation(int offset, int length, String replaceWith) {
        this.fReplaceWith = replaceWith;
        this.fOffset = offset;
        this.fLength = length;
    }

    public void perform(IDocument doc, Map varReplacements) throws BadLocationException {
        String actualReplace = this.fReplaceWith;
        if (varReplacements != null) {
            Iterator it = varReplacements.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String varPattern = "\\$\\{\\Q" + entry.getKey().toString() + "\\E\\}";
                String sub = entry.getValue().toString();
                actualReplace = actualReplace.replaceAll(varPattern, sub);
            }
        }
        doc.replace(this.fOffset, this.fLength, actualReplace);
    }

    public static DocumentTextOperation newTextDeletion(int offset, int length) {
        return new DocumentTextOperation(offset, length, EMPTY);
    }

    public static DocumentTextOperation newTextInsertion(int offset, String insert) {
        return new DocumentTextOperation(offset, 0, insert);
    }

    public static DocumentTextOperation newTextReplacement(int offset, int length, String replacement) {
        return new DocumentTextOperation(offset, length, replacement);
    }
}

