/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.refactoring;

import java.util.LinkedList;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;

public class SortedOperationList
implements Cloneable {
    private LinkedList fList = new LinkedList();
    private int middle = -1;

    public void add(DocumentTextOperation o) {
        int adder = 1;
        int start = Math.max(this.middle, 0);
        if (this.middle > 0) {
            int off = ((DocumentTextOperation)this.fList.get((int)this.middle)).fOffset;
            int diff = o.fOffset - off;
            adder = diff / Math.abs(diff);
        }
        if (this.fList.size() == 0) {
            this.fList.add(o);
        } else {
            int currSize = this.fList.size();
            int i = start;
            while (i >= 0 && i <= currSize) {
                if (i == this.fList.size() || ((DocumentTextOperation)this.fList.get((int)i)).fOffset > o.fOffset) {
                    this.fList.add(i, o);
                }
                i += adder;
            }
        }
        this.middle = this.fList.size() / 2;
    }

    public boolean remove(DocumentTextOperation o) {
        return this.fList.remove(o);
    }

    public DocumentTextOperation removeFirst() {
        return (DocumentTextOperation)this.fList.removeFirst();
    }

    public DocumentTextOperation removeLast() {
        return (DocumentTextOperation)this.fList.removeLast();
    }

    public DocumentTextOperation[] toArray() {
        return this.fList.toArray(new DocumentTextOperation[this.fList.size()]);
    }

    public Object clone() throws CloneNotSupportedException {
        SortedOperationList list = (SortedOperationList)super.clone();
        list.fList.addAll(this.fList);
        list.middle = this.middle;
        return list;
    }
}

