/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class GroupedArrayList {
    protected HashMap fIndex;
    protected HashMap fbIndex;
    protected ArrayList groups;

    public GroupedArrayList(int n) {
        this.fIndex = new HashMap(n);
        this.fbIndex = new HashMap(n);
        this.groups = new ArrayList(n);
    }

    public int getGroupIndex(String name) {
        return (Integer)this.fIndex.get(name);
    }

    public String getGroupName(int index) {
        return (String)this.fbIndex.get(new Integer(index));
    }

    public ArrayList getGroup(int index) {
        return (ArrayList)this.groups.get(index);
    }

    public ArrayList getGroup(String name) {
        int group = this.getGroupIndex(name);
        return (ArrayList)this.groups.get(group);
    }

    public int addGroup(String name) {
        this.groups.add(new ArrayList());
        int newIndex = this.groups.size() - 1;
        Integer i = new Integer(newIndex);
        this.fIndex.put(name, i);
        this.fbIndex.put(i, name);
        return newIndex;
    }

    public ArrayList deleteGroup(int index) {
        ArrayList al = (ArrayList)this.groups.remove(index);
        Object name = this.fbIndex.remove(new Integer(index));
        this.fIndex.remove(name);
        return al;
    }

    public ArrayList deleteGroup(String name) {
        return this.deleteGroup(this.getGroupIndex(name));
    }

    public void addToGroup(String groupname, Object o) {
        this.getGroup(groupname).add(o);
    }

    public void addAllToGroup(String groupname, Collection c) {
        this.getGroup(groupname).addAll(c);
    }

    public void addAllToGroup(String groupname, Object[] o) {
        this.addAllToGroup(groupname, Arrays.asList(o));
    }

    public void removeFromGroup(String groupname, Object o) {
        this.getGroup(groupname).remove(o);
    }

    public void removeAllFromGroup(String groupname, Collection c) {
        this.getGroup(groupname).removeAll(c);
    }

    public void removeAllFromGroup(String groupname, Object[] o) {
        this.removeAllFromGroup(groupname, Arrays.asList(o));
    }

    public int size() {
        int totalsize = 0;
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            ArrayList al = (ArrayList)it.next();
            totalsize += al.size();
        }
        return totalsize;
    }

    protected ArrayList getCombinedList() {
        ArrayList merge = new ArrayList(this.size());
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            ArrayList al = (ArrayList)it.next();
            merge.addAll(al);
        }
        return merge;
    }

    public Object[] toArray() {
        return this.getCombinedList().toArray();
    }

    public Object[] toArray(Object[] o) {
        return this.getCombinedList().toArray(o);
    }
}

