/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.kenya.util;

import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.multieditor.kenya.util.SourceCodeLocationComparator;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.node.Node;
import minijava.node.Token;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class LocationUtils {
    private LocationUtils() {
    }

    public static ISourceCodeLocation getLocation(Token t) {
        return new SourceCodeLocation(t.getLine(), t.getPos(), t.getText().length());
    }

    public static ISourceCodeLocation convert(Position pos, IDocument doc) {
        try {
            int line = doc.getLineOfOffset(pos.getOffset());
            int col = pos.getOffset() - doc.getLineOffset(line);
            int len = pos.getLength();
            return new SourceCodeLocation(line + 1, col + 1, len);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static ISourceCodeLocation convert(int offset, int length, IDocument doc) {
        return LocationUtils.convert(new Position(offset, length), doc);
    }

    public static Position convert(ISourceCodeLocation loc, IDocument doc) {
        try {
            IRegion reg = doc.getLineInformation(loc.getLineNumber() - 1);
            return new Position(reg.getOffset() + Math.max(loc.getColumnNumber() - 1, 0), loc.getTokenLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean occursBefore(Node n1, Node n2) {
        ISourceCodeLocation l1 = NodeTools.getLocation(n1);
        ISourceCodeLocation l2 = NodeTools.getLocation(n2);
        return LocationUtils.occursBefore(l1, l2);
    }

    public static boolean occursBefore(ISourceCodeLocation l1, ISourceCodeLocation l2) {
        return SourceCodeLocationComparator.getInstance().compare(l1, l2) <= 0;
    }
}

