/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.text;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class CodeReader
extends Reader {
    public static final int EOF = -1;
    private boolean fSkipComments = false;
    private boolean fSkipStrings = false;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private int fCachedLineNumber = -1;
    private int fCachedLineOffset = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipComments, boolean skipStrings) throws IOException {
        this.fDocument = document;
        this.fOffset = offset;
        this.fSkipComments = skipComments;
        this.fSkipStrings = skipStrings;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + length);
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipComments, boolean skipStrings) throws IOException {
        this.fDocument = document;
        this.fOffset = offset;
        this.fSkipComments = skipComments;
        this.fSkipStrings = skipStrings;
        this.fForward = false;
        try {
            this.fCachedLineNumber = this.fDocument.getLineOfOffset(this.fOffset);
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    private void gotoCommentEnd() throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char current;
            if ((current = this.fDocument.getChar(this.fOffset++)) != '*' || this.fOffset >= this.fEnd || this.fDocument.getChar(this.fOffset) != '/') continue;
            ++this.fOffset;
            return;
        }
    }

    private void gotoStringEnd(char delimiter) throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char current;
            if ((current = this.fDocument.getChar(this.fOffset++)) == '\\') {
                ++this.fOffset;
                continue;
            }
            if (current != delimiter) continue;
            return;
        }
    }

    private void gotoLineEnd() throws BadLocationException {
        int line = this.fDocument.getLineOfOffset(this.fOffset);
        this.fOffset = this.fDocument.getLineOffset(line + 1);
    }

    private int readForwards() throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char current = this.fDocument.getChar(this.fOffset++);
            switch (current) {
                case '/': {
                    if (this.fSkipComments && this.fOffset < this.fEnd) {
                        char next = this.fDocument.getChar(this.fOffset);
                        if (next == '*') {
                            ++this.fOffset;
                            this.gotoCommentEnd();
                            break;
                        }
                        if (next == '/') {
                            this.gotoLineEnd();
                            break;
                        }
                    }
                    return current;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        this.gotoStringEnd(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    private void handleSingleLineComment() throws BadLocationException {
        int line = this.fDocument.getLineOfOffset(this.fOffset);
        if (line < this.fCachedLineNumber) {
            this.fCachedLineNumber = line;
            this.fCachedLineOffset = this.fDocument.getLineOffset(line);
            int offset = this.fOffset;
            while (this.fCachedLineOffset < offset) {
                char current;
                if ((current = this.fDocument.getChar(offset--)) != '/' || this.fCachedLineOffset > offset || this.fDocument.getChar(offset) != '/') continue;
                this.fOffset = offset;
                return;
            }
        }
    }

    private void gotoCommentStart() throws BadLocationException {
        while (this.fOffset > 0) {
            char current;
            if ((current = this.fDocument.getChar(this.fOffset--)) != '*' || this.fOffset < 0 || this.fDocument.getChar(this.fOffset) != '/') continue;
            return;
        }
    }

    private void gotoStringStart(char delimiter) throws BadLocationException {
        while (this.fOffset > 0) {
            char current = this.fDocument.getChar(this.fOffset);
            if (current == delimiter && (this.fOffset < 0 || this.fDocument.getChar(this.fOffset - 1) != '\\')) {
                return;
            }
            --this.fOffset;
        }
    }

    private int readBackwards() throws BadLocationException {
        while (this.fOffset > 0) {
            --this.fOffset;
            this.handleSingleLineComment();
            char current = this.fDocument.getChar(this.fOffset);
            switch (current) {
                case '/': {
                    char next;
                    if (this.fSkipComments && this.fOffset > 1 && (next = this.fDocument.getChar(this.fOffset - 1)) == '*') {
                        this.fOffset -= 2;
                        this.gotoCommentStart();
                        break;
                    }
                    return current;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        --this.fOffset;
                        this.gotoStringStart(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int i = off;
        while (i < end) {
            int ch = this.read();
            if (ch == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)ch;
            ++i;
        }
        return len;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public String getString() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = this.read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

