/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.text;

import java.util.LinkedList;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.text.SimpleFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                TextEdit edit = SimpleFormatter.format(document.get(), partition.offset, partition.length, document.getLineDelimiter(0));
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException exception) {
                KenyaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                KenyaPlugin.log(exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

