/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import kenya.eclipse.KenyaPlugin;
import mediator.IJavaCode;
import mediator.subscription.IJavaCodeReceiver;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GeneratedJava
implements IStorage,
IJavaCodeReceiver {
    private IJavaCode code = null;
    private boolean change = false;
    private String name;

    public GeneratedJava(String classname) {
        this.name = classname;
    }

    public InputStream getContents() throws CoreException {
        this.change = false;
        return new ByteArrayInputStream(this.getStringContents(this.code).getBytes());
    }

    public String getContentsAsString() throws CoreException {
        String s = this.getStringContents(this.code);
        this.change = false;
        return s;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setJavaCode(IJavaCode code) {
        if (this.code != null && !this.codeIsEquivalent(this.code, code) || this.code == null) {
            this.code = code;
            this.change = true;
        }
    }

    protected String getStringContents(IJavaCode jcode) throws CoreException {
        if (jcode != null) {
            String s = "";
            Reader content = jcode.getCode(this.name);
            try {
                char c;
                while (Character.isDefined(c = (char)content.read())) {
                    s = String.valueOf(s) + c;
                }
                return s;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, KenyaPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
        }
        return "Kenya code contains errors, can not translate to Java.";
    }

    private boolean codeIsEquivalent(IJavaCode code2, IJavaCode code3) {
        try {
            return this.getStringContents(code2).equals(this.getStringContents(code3));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean hasChanged() {
        return this.change;
    }

    public Object getAdapter(Class adapter) {
        if (this.getClass().isAssignableFrom(adapter)) {
            return this;
        }
        return null;
    }
}

