/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.multieditor.util;

import kenya.eclipse.KenyaPlugin;
import mediator.subscription.MediationService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.SWTException;

public class KenyaHelperThread
extends Job {
    private final String subID;
    private boolean stop = false;
    private long lastKeyEvent = 0L;
    private DocumentChangeListener lkec;
    private long sleepPeriod = 500L;
    private long timeout = 1000L;

    public KenyaHelperThread(String name, String subID) {
        super(name);
        this.subID = subID;
        this.setSystem(true);
    }

    public IDocumentListener getDocumentListener() {
        if (this.lkec == null) {
            this.lkec = new DocumentChangeListener();
        }
        return this.lkec;
    }

    private void doRequestUpdate() {
        MediationService.getInstance().provideASyncSubscriptionUpdate(this.subID);
    }

    protected boolean itsTimeToParseKenya() {
        return System.currentTimeMillis() > this.lastKeyEvent + this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stoppit() {
        this.stop = true;
        this.wakeUp();
        KenyaHelperThread kenyaHelperThread = this;
        synchronized (kenyaHelperThread) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            while (!this.stop) {
                KenyaHelperThread kenyaHelperThread = this;
                synchronized (kenyaHelperThread) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    while (!this.stop && !this.itsTimeToParseKenya()) {
                        try {
                            ((Object)((Object)this)).wait(this.sleepPeriod);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.stop) {
                        this.doRequestUpdate();
                    }
                }
            }
        }
        catch (SWTException e) {
            KenyaPlugin.log(e);
        }
        catch (NullPointerException nullPointerException) {}
        return Status.OK_STATUS;
    }

    class DocumentChangeListener
    implements IDocumentListener {
        DocumentChangeListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(DocumentEvent event) {
            KenyaHelperThread.this.lastKeyEvent = System.currentTimeMillis();
            KenyaHelperThread kenyaHelperThread = KenyaHelperThread.this;
            synchronized (kenyaHelperThread) {
                ((Object)((Object)KenyaHelperThread.this)).notifyAll();
            }
        }
    }
}

