/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.buildext.AbstractKenyaPostBuildAnalyser;
import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.KenyaStyleManager;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractStylePostBuildAnalyser
extends AbstractKenyaPostBuildAnalyser {
    protected IFile fFile;

    protected abstract IStyleChecker[] getCheckersToExecute();

    private AbstractStylePostBuildAnalyser() {
    }

    public AbstractStylePostBuildAnalyser(IFile file) {
        this();
        this.fFile = file;
    }

    public void setCheckedCode(final ICheckedCode code) {
        Job run = new Job("KenyaStyleChecking"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    AbstractStylePostBuildAnalyser.this.fFile.deleteMarkers(KenyaStyleConstants.KENYA_STYLE_MARKER, false, 0);
                    KenyaStyleManager.getResolutionManager().clearResolutions(AbstractStylePostBuildAnalyser.this.fFile);
                }
                catch (CoreException coreException) {
                    return Status.OK_STATUS;
                }
                IStyleChecker[] checkers = AbstractStylePostBuildAnalyser.this.getCheckersToExecute();
                int totalWork = 1 + checkers.length;
                monitor.beginTask(this.getName(), totalWork);
                int i = 0;
                while (true) {
                    Object var7_7;
                    if (i >= checkers.length) {
                        monitor.worked(1);
                        return Status.OK_STATUS;
                    }
                    if (monitor.isCanceled() || !AbstractStylePostBuildAnalyser.this.fFile.isAccessible()) {
                        return Status.CANCEL_STATUS;
                    }
                    IStyleChecker c = checkers[i];
                    monitor.subTask("Executing - " + c.getDescriptor().getName());
                    try {
                        try {
                            c.performCheck(code, AbstractStylePostBuildAnalyser.this.fFile);
                            KenyaStyleManager.getResolutionManager().addResolutions(AbstractStylePostBuildAnalyser.this.fFile, c.getMarkerResolutionMap());
                        }
                        catch (Exception e) {
                            KenyaPlugin.log("Error while executing StyleChecker \"" + c.getDescriptor().getName() + "\": " + e, e);
                        }
                    }
                    catch (Throwable throwable) {
                        var7_7 = null;
                        monitor.worked(1);
                        throw throwable;
                    }
                    {
                        var7_7 = null;
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
        };
        run.setSystem(true);
        run.schedule();
    }

    public void setJavaCode(IJavaCode code) {
    }
}

