/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.KenyaStyleResolutionManager;
import kenya.eclipse.style.StyleCheckRegistry;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.checkerimpl.StyleCheckerDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class KenyaStyleManager {
    public static final String KENYA_STYLE_ID = "kenya.eclipse.KenyaStyleManager";
    private static StyleCheckRegistry fStyleRegistry;
    private static KenyaStyleResolutionManager fResolutionManager;

    public static StyleCheckRegistry getStyleCheckRegistry() {
        if (fStyleRegistry == null) {
            KenyaStyleManager.initialiseStyleRegistry();
        }
        return fStyleRegistry;
    }

    private static void initialiseStyleRegistry() {
        fStyleRegistry = new StyleCheckRegistry();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(KenyaPlugin.getPluginId(), "styleCheckers");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            try {
                String id = infos[i].getAttribute("id");
                String name = infos[i].getAttribute("name");
                String defEnabled = infos[i].getAttribute("defaultEnabled");
                String namespace = infos[i].getDeclaringExtension().getNamespace();
                IStyleChecker checker = (IStyleChecker)infos[i].createExecutableExtension("class");
                IConfigurationElement[] custom = infos[i].getChildren("customAttribute");
                HashMap<String, String> customAttributes = new HashMap<String, String>(custom.length);
                int j = 0;
                while (j < custom.length) {
                    IConfigurationElement data = custom[j];
                    String cname = data.getAttribute("name");
                    String cvalue = data.getAttribute("value");
                    customAttributes.put(cname, cvalue);
                    ++j;
                }
                checker.configure(customAttributes);
                QualifiedName qn = new QualifiedName(namespace, id);
                boolean enabled = defEnabled == null || defEnabled.equals(KenyaStyleConstants.ENABLED);
                StyleCheckerDescriptor desc = new StyleCheckerDescriptor(qn, name, checker, enabled);
                fStyleRegistry.registerStyleChecker(desc);
            }
            catch (CoreException e) {
                KenyaPlugin.log(e);
            }
            catch (ClassCastException e) {
                KenyaPlugin.log(e);
            }
            ++i;
        }
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = KenyaPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static KenyaStyleResolutionManager getResolutionManager() {
        if (fResolutionManager == null) {
            fResolutionManager = new KenyaStyleResolutionManager();
        }
        return fResolutionManager;
    }

    public static boolean hasCorrections(Annotation annotation) {
        if (annotation instanceof SimpleMarkerAnnotation) {
            SimpleMarkerAnnotation a = (SimpleMarkerAnnotation)annotation;
            return KenyaStyleManager.getResolutionManager().hasResolutions(a.getMarker());
        }
        return false;
    }
}

