/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kenya.eclipse.style.KenyaStyleManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class KenyaStyleResolutionManager
implements IMarkerResolutionGenerator2 {
    private Map fResolutionMap;

    public boolean hasResolutions(IMarker marker) {
        if (this == KenyaStyleManager.getResolutionManager()) {
            return this.fResolutionMap != null && this.fResolutionMap.get(marker.getResource()) != null && ((Map)this.fResolutionMap.get(marker.getResource())).get(marker) != null;
        }
        return KenyaStyleManager.getResolutionManager().hasResolutions(marker);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (this == KenyaStyleManager.getResolutionManager()) {
            IMarkerResolution[] resolutions;
            Map m;
            if (this.fResolutionMap != null && (m = (Map)this.fResolutionMap.get(marker.getResource())) != null && (resolutions = (IMarkerResolution[])m.get(marker)) != null) {
                return resolutions;
            }
            return new IMarkerResolution[0];
        }
        return KenyaStyleManager.getResolutionManager().getResolutions(marker);
    }

    void addResolutions(IMarker marker, IMarkerResolution[] resolutions) {
        IFile file = (IFile)marker.getResource();
        HashMap<IMarker, IMarkerResolution[]> map = new HashMap<IMarker, IMarkerResolution[]>(1);
        map.put(marker, resolutions);
        this.addResolutionsWithoutCheck(file, map);
    }

    void addResolutions(IFile file, Map resolutionMap) {
        this.checkTypes(resolutionMap);
        this.addResolutionsWithoutCheck(file, resolutionMap);
    }

    private void checkTypes(Map map) {
        Set s = map.entrySet();
        HashMap ax = new HashMap(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (e.getValue() instanceof IMarkerResolution[]) continue;
            if (e.getValue() instanceof IMarkerResolution) {
                IMarkerResolution res = (IMarkerResolution)e.getValue();
                ax.put(e.getKey(), new IMarkerResolution[]{res});
                it.remove();
                continue;
            }
            it.remove();
        }
        map.putAll(ax);
    }

    private void addResolutionsWithoutCheck(IFile file, Map resolutionMap) {
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap();
        }
        if (!this.fResolutionMap.containsKey(file)) {
            HashMap map = new HashMap();
            this.fResolutionMap.put(file, map);
        }
        ((Map)this.fResolutionMap.get(file)).putAll(resolutionMap);
    }

    void clearResolutions(IFile file) {
        if (this.fResolutionMap != null && this.fResolutionMap.containsKey(file)) {
            this.fResolutionMap.remove(file);
        }
    }

    void clearResolutions(IMarker marker) {
        Map m;
        if (this.fResolutionMap != null && (m = (Map)this.fResolutionMap.get(marker.getResource())) != null) {
            m.remove(marker);
        }
    }
}

