/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checkerimpl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.buildext.util.MarkerPropertySetter;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.checkerimpl.IStyleCheckerDescriptor;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class AbstractStyleChecker
implements IStyleChecker {
    public static final String KENYA_STYLE_MARKER = KenyaStyleConstants.KENYA_STYLE_MARKER;
    private IStyleCheckerDescriptor fDescriptor;
    protected Map fResolutionMap;

    public void setDescriptor(IStyleCheckerDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public IStyleCheckerDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public Map getMarkerResolutionMap() {
        return this.fResolutionMap != null ? this.fResolutionMap : new HashMap(0);
    }

    public static boolean overlapsWithError(Node node, ICheckedCode code) {
        if (!code.isErroredCode()) {
            return false;
        }
        ISourceCodeLocation loc = NodeTools.getLocation(node);
        int line = loc.getLineNumber();
        int col = loc.getColumnNumber();
        int end = col + loc.getTokenLength();
        List errs = code.getErrors();
        Iterator iter = errs.iterator();
        while (iter.hasNext()) {
            ISourceCodeError element = (ISourceCodeError)iter.next();
            ISourceCodeLocation errLoc = element.getLocation();
            int eLine = errLoc.getLineNumber();
            int eCol = errLoc.getColumnNumber();
            int eEnd = eCol + errLoc.getTokenLength();
            if (line != eLine || !(col <= eCol && eCol <= end || eCol <= col && col <= eEnd || col <= eEnd && eEnd <= end) && (eCol > end || end > eEnd)) continue;
            return true;
        }
        return false;
    }

    protected static void runMarkerUpdate(IWorkspaceRunnable wr) {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 1, null);
        }
        catch (CoreException e) {
            KenyaPlugin.log(e);
        }
    }

    protected static IDocument getDocument(IFile file) {
        FileEditorInput fei = new FileEditorInput(file);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)fei);
        IDocument doc = provider.getDocument((Object)fei);
        return doc;
    }

    protected static Position calculatePosition(ISourceCodeLocation loc, IDocument doc) {
        return LocationUtils.convert(loc, doc);
    }

    protected static IMarker createKenyaStyleMarker(IFile file, ISourceCodeLocation loc, String message) throws CoreException {
        IMarker m = file.createMarker(KENYA_STYLE_MARKER);
        IDocument doc = AbstractStyleChecker.getDocument(file);
        Position pos = AbstractStyleChecker.calculatePosition(loc, doc);
        HashMap<String, Object> atts = new HashMap<String, Object>(4);
        atts.put("severity", new Integer(1));
        atts.put("lineNumber", new Integer(loc.getLineNumber()));
        atts.put("userEditable", Boolean.FALSE);
        atts.put("message", message);
        m.setAttributes(atts);
        MarkerPropertySetter.setLocation(m, pos);
        return m;
    }
}

